% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chords.R
\name{chord_invert}
\alias{chord_invert}
\title{Chord inversion}
\usage{
chord_invert(chord, n = 0, limit = FALSE)
}
\arguments{
\item{chord}{character, a single chord.}

\item{n}{inversion.}

\item{limit}{logical, limit inversions in either direction to one less than the number of notes in the chord.}
}
\value{
character
}
\description{
This function inverts a single chord given as a character string. If \code{n = 0}, \code{chord} is returned immediately.
Otherwise, the notes of the chord are inverted. If \code{abs(n)} is greater than the number of inversions (excluding root position), an error is thrown.
}
\details{
Note that \code{chord_invert} has no knowledge of whether a chord might be considered as in root position or some inversion already, as informed by a key signature, chord name or user's intent.
This function simply inverts what it receives, treating any defined chord string as in root position.

Octave number applies to this function. Chords should always be defined by notes of increasing pitch. Remember that an unspecified octave number on a note is octave 3.
When the chord is inverted, it moves up the scale.
The lowest note is moved to the top of the chord, increasing its octave if necessary, to ensure that the note takes the lowest octave number while having the highest pitch.
The second lowest note becomes the lowest. It's octave does not change.
This pattern is repeated for higher order inversions. The opposite happens if \code{n} is negative.

The procedure ensures that the resulting inverted chord is still defined by notes of increasing pitch.
However, if you construct an unusual chord that spans multiple octaves, the extra space will be condensed by inversion.
}
\examples{
chord_invert("ce_gb_", 3)
}
