% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hardhat.R
\name{tabnet_fit}
\alias{tabnet_fit}
\alias{tabnet_fit.default}
\alias{tabnet_fit.data.frame}
\alias{tabnet_fit.formula}
\alias{tabnet_fit.recipe}
\title{Tabnet model}
\usage{
tabnet_fit(x, ...)

\method{tabnet_fit}{default}(x, ...)

\method{tabnet_fit}{data.frame}(x, y, ...)

\method{tabnet_fit}{formula}(formula, data, ...)

\method{tabnet_fit}{recipe}(x, data, ...)
}
\arguments{
\item{x}{Depending on the context:
\itemize{
\item A \strong{data frame} of predictors.
\item A \strong{matrix} of predictors.
\item A \strong{recipe} specifying a set of preprocessing steps
created from \code{\link[recipes:recipe]{recipes::recipe()}}.
}

The predictor data should be standardized (e.g. centered or scaled).
The model treats categorical predictors internally thus, you don't need to
make any treatment.}

\item{...}{Model hyperparameters. See \code{\link[=tabnet_config]{tabnet_config()}} for a list of
all possible hyperparameters.}

\item{y}{When \code{x} is a \strong{data frame} or \strong{matrix}, \code{y} is the outcome
specified as:
\itemize{
\item A \strong{data frame} with 1 numeric column.
\item A \strong{matrix} with 1 numeric column.
\item A numeric \strong{vector}.
}}

\item{formula}{A formula specifying the outcome terms on the left-hand side,
and the predictor terms on the right-hand side.}

\item{data}{When a \strong{recipe} or \strong{formula} is used, \code{data} is specified as:
\itemize{
\item A \strong{data frame} containing both the predictors and the outcome.
}}
}
\value{
A TabNet model object. It can be used for serialization and predictions.
}
\description{
Fits the \href{https://arxiv.org/abs/1908.07442}{TabNet: Attentive Interpretable Tabular Learning} model
}
\section{Threading}{


TabNet uses \code{torch} as it's backend for computation and \code{torch} uses all
available threads by default.

You can control the number of threads used by \code{torch} with:\preformatted{torch::torch_set_num_threads(1)
torch::torch_set_num_interop_threads(1)
}
}

\examples{
if (torch::torch_is_installed()) {
data("ames", package = "modeldata")
fit <- tabnet_fit(Sale_Price ~ ., data = ames, epochs = 1)
}

}
