% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table1.R
\name{table.rows}
\alias{table.rows}
\alias{table.data}
\title{Convert to HTML table rows.}
\usage{
table.rows(
  x,
  row.labels = rownames(x),
  th = FALSE,
  class = NULL,
  rowlabelclass = "rowlabel",
  firstrowclass = "firstrow",
  lastrowclass = "lastrow",
  ...
)

table.data(
  x,
  row.labels = rownames(x),
  th = FALSE,
  class = NULL,
  rowlabelclass = "rowlabel",
  firstrowclass = "firstrow",
  lastrowclass = "lastrow",
  ...
)
}
\arguments{
\item{x}{A vector or table-like structure (e.g. a \code{\link{data.frame}} or \code{\link{matrix}}).}

\item{row.labels}{Values for the first column, typically used to label the row, or \code{NULL} to omit.}

\item{th}{A logical. Should \code{th} tags be used rather than \code{td}?}

\item{class}{HTML class attribute. Can be a single \code{character}, a vector or a matrix.}

\item{rowlabelclass}{HTML class attribute for the row labels (i.e. first column).}

\item{firstrowclass}{HTML class attribute for the first row of cells.}

\item{lastrowclass}{HTML class attribute for the last row of cells.}

\item{...}{Additional arguments.}
}
\value{
A \code{character} which contains an HTML table fragment.
}
\description{
Many functions exist in R to generate HTML tables.  These functions are
useful for generating HTML table fragments (rather than whole tables), which
can then be used to build up complete tables. The first column my be used to
label the rows of the table. Row labels, if specified, can have a special
HTML \code{class} designated, which can be useful as a hook to customize
their appearance using CSS. The same is true for the the first and last row
of cells.
}
\section{Functions}{
\itemize{
\item \code{table.data}: Convert to HTML table data (cells).
}}

\examples{
x <- matrix(signif_pad(exp(rnorm(5*5, 1, 1))), 5, 5)
table.data(x)
cat(table.rows(x, NULL))
cat(table.rows(x, LETTERS[1:nrow(x)]))
cat(table.rows(LETTERS[1:3], "Headings", th=TRUE))
}
\keyword{utilities}
