% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table1.R
\name{stats.apply.rounding}
\alias{stats.apply.rounding}
\title{Apply rounding to basic descriptive statistics.}
\usage{
stats.apply.rounding(
  x,
  digits = 3,
  digits.pct = 1,
  round.median.min.max = TRUE,
  round.integers = TRUE,
  round5up = TRUE,
  ...
)
}
\arguments{
\item{x}{A list, such as that returned by \code{\link{stats.default}}.}

\item{digits}{An integer specifying the number of significant digits to keep.}

\item{digits.pct}{An integer specifying the number of digits after the
decimal place for percentages.}

\item{round.median.min.max}{Should rounding applied to median, min and max?}

\item{round.integers}{Should rounding be limited to digits to the right of
the decimal point?}

\item{round5up}{Should numbers with 5 as the last digit always be rounded
up? The standard R approach is "go to the even digit" (IEC 60559 standard,
see \code{\link{round}}), while some other softwares (e.g. SAS, Excel)
always round up.}

\item{...}{Further arguments.}
}
\value{
A list with the same number of elements as \code{x}. The rounded
values will be \code{character} (not \code{numeric}) and will have 0 padding
to ensure consistent number of significant digits.
}
\description{
Not all statistics should be rounded in the same way, or at all. This
function will apply rounding selectively to a list of statistics as returned
by \code{\link{stats.default}}. In particular we don't round counts (N and
FREQ), and for MIN, MAX and MEDIAN the \code{digits} is interpreted as the
\emph{minimum} number of significant digits, so that we don't loose any
precision. Percentages are rounded to a fixed number of decimal places
(default 1) rather than a specific number of significant digits.
}
\examples{
x <- round(exp(rnorm(100, 1, 1)), 6)
stats.default(x)
stats.apply.rounding(stats.default(x), digits=3)
stats.apply.rounding(stats.default(round(x, 1)), digits=3)

}
\seealso{
\code{\link{signif_pad}}
\code{\link{stats.default}}
}
\keyword{utilities}
