% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-max_by.R, R/VERBS-min_by.R
\name{extrema_by}
\alias{extrema_by}
\alias{max_by}
\alias{max_by.ExprBuilder}
\alias{max_by.data.table}
\alias{min_by}
\alias{min_by.ExprBuilder}
\alias{min_by.data.table}
\title{Find rows with extrema in specific columns}
\usage{
max_by(.data, .col, ...)

\method{max_by}{ExprBuilder}(.data, .col, ..., .some = FALSE,
  .chain = getOption("table.express.chain", TRUE))

\method{max_by}{data.table}(.data, .col, ..., .expr = FALSE)

min_by(.data, .col, ...)

\method{min_by}{ExprBuilder}(.data, .col, ..., .some = FALSE,
  .chain = getOption("table.express.chain", TRUE))

\method{min_by}{data.table}(.data, .col, ..., .expr = FALSE)
}
\arguments{
\item{.data}{An instance of \link{ExprBuilder}.}

\item{.col}{A character vector indicating the columns that will be searched for extrema.}

\item{...}{Optionally, columns to group by, either as characters or symbols.}

\item{.some}{If \code{TRUE} the rows where \emph{any} of the columns specified in \code{.col} have extrema are
returned.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}

\item{.expr}{If the input is a \code{data.table} and \code{.expr} is \code{TRUE}, an instance of
\link{EagerExprBuilder} will be returned. Useful if you want to add clauses to \code{j}, e.g. with
\link{mutate-table.express}.}
}
\description{
Find rows with maxima/minima in given columns.
}
\details{
These verbs implement the idiom shown \href{https://stackoverflow.com/q/16573995/5793905}{here} by
leveraging \code{\link[=nest_expr]{nest_expr()}}. The whole nested expression is assigned to \code{i} in the \code{data.table}'s
frame. It is probably a good idea to use this on a frame that has no other frames preceding it
in the current expression, given that \code{\link[=nest_expr]{nest_expr()}} uses the captured \code{data.table}, so consider
using \code{\link[=chain]{chain()}} when needed.

Several columns can be specified in \code{.col}, and depending on the value of \code{.some}, the rows with
all or some extrema are returned, using \code{&} or \code{|} respectively. Depending on your data, using
more than one column might not make sense, resulting in an empty \code{data.table}.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    max_by("mpg", "vs")

}
