% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.isotopeData.R
\name{plot.isotopeData}
\alias{plot.isotopeData}
\title{Plot stable isotope data (2 elements) with one or two baselines}
\usage{
\method{plot}{isotopeData}(
  x,
  consumer = NULL,
  b1 = NULL,
  b2 = NULL,
  legend = c(1.15, 1.15),
  density = "both",
  xylim = NULL,
  ...
)
}
\arguments{
\item{x}{an isotopeData class object.}

\item{consumer}{string representing the consumer.}

\item{b1}{string representing baseline 1.}

\item{b2}{string representing baseline 2.}

\item{legend}{coordinates representing where to locate the legend.}

\item{density}{string representing whether the density function is plotted.
Accepted characters are "both" in which case this function will plot the
density function above and to the right, "right", "above" or "none".}

\item{xylim}{argument for modifying x-y limits (for testing)}

\item{...}{additional arguments passed to this function.}
}
\value{
a ggplot2 object with the biplot of isotopes.
}
\description{
Plot stable isotope data (2 elements) with one or two baselines
}
\examples{
a <- generateTPData()
plot(a)

}
