% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{findFeasibleMatrix}
\alias{findFeasibleMatrix}
\title{Finds a Nonnegative Matrix Satisfying Row and Column Sums}
\usage{
findFeasibleMatrix(r, c, p, eps = 1e-09)
}
\arguments{
\item{r}{vector of row sums (nonnegative}

\item{c}{vector of column sums (nonnegative)}

\item{p}{matrix of probabilities (must be in [0,1]), matching the dimensions of r and c. Values of p=0 are interpreted that the corresponding matrix elements have to be 0. Note: p=1 does not force the corresponding matrix element to exist.}

\item{eps}{row and col sums can at most be different by eps.  Default 1e-9.}
}
\value{
A feasible matrix.
}
\description{
Given row and column sums and a matrix p which indicates which elements of the matrix can be present, this function computes a nonnegative matrix that match these row and column sums. If this is not possible then the function returns an error message.
}
\details{
The function transforms the problem into a Maximum Flow
problem of a graph and uses the Edmonds-Karps algorithm to solve it.
If the error message "Could not find feasible matrix." is produced then this could be
due to p imposing disconnected components in the graph implied
by row and column sums that are not compatible with the row and column sums..
}
\examples{
p=matrix(c(1,0,0,1),nrow=2)
findFeasibleMatrix(c(1,1),c(1,1),p=p)

n <- 4
M <- matrix(nrow=n,ncol=n,rexp(n*n)*(runif(n*n)>0.6))
M
r <- rowSums(M)
c <- colSums(M)
Mnew <- findFeasibleMatrix(r=r,c=c,p=(M>0)*0.5)
Mnew
rowSums(M);rowSums(Mnew)
colSums(M);colSums(Mnew)
}

