% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_data-documentation.R
\docType{data}
\name{stateFR}
\alias{stateFR}
\title{Birth rates, by age of mother: United States, each state and territory, 2014}
\format{
A \code{data.frame} with 612 observations and 3 variables.
\describe{
 \item{state}{The state or territory for which data was was recorded.}
 \item{age_group}{The age group of the mother.}
 \item{birth_rate}{The birth rate. See Details.}
}
}
\source{
\url{http://www.cdc.gov/nchs/nvss/births.htm}
}
\usage{
stateFR
}
\description{
A dataset containing birth rate data by US state and age for all 
US states and territories in 2014.
}
\section{Details}{

\itemize{
 \item{The birth rate is defined as births per 1,000 women in the specified group.}
 \item{Birth rates for \code{age_group} 45_49 are computed by relating births to women aged 45 and 
 over to women aged 45-49}
 \item{Data for the "United States" as a whole excludes data for the territories.}
 \item{Data is missing (eg. \code{NA}) when data does not meet standards of reliability or percision; 
 birth rates based on fewer than 20 births.}
}
}

\references{
Hamilton, Brady E., et al. "Births: final data for 2014." National Vital Statistics 
Reports 64.12 (2015): 1-64.
}
\keyword{datasets}
