% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_synth_data.R
\name{pull_acs_basetables}
\alias{pull_acs_basetables}
\title{Pull ACS base tables}
\usage{
pull_acs_basetables(endyear, span, geography, table_vec)
}
\arguments{
\item{endyear}{An integer, indicating the latest year of the data in the survey.}

\item{span}{An integer in \code{c(1,3,5)} indicating the span of the desired data.}

\item{geography}{a valid \code{geo.set} object specifying the census geography or 
geographies to be fetched.}

\item{table_vec}{A \code{character} vector specifying ACS base tables.}
}
\value{
A \code{'macroACS'} class object
}
\description{
A wrapper function to pull multiple base tables from ACS API via 
\code{\link[acs]{acs.fetch}}.
}
\examples{
\dontrun{
# make geography
la_geo <- acs::geo.make(state= "CA", county= "Los Angeles")
# pull data 
la_dat <- pull_acs_basetables(endyear= 2015, span= 1, geography= la_geo, 
  table_vec= c("B01001", "B01002", "B01003"))
}
}
\references{
\url{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.html}
}
