% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct2env.R
\name{ct2env}
\alias{ct2env}
\title{Establishing the relationship between CT and a environmental variable}
\usage{
ct2env(x, clas, fun = mean, out = "data.frame")
}
\arguments{
\item{x}{data.frame. A data.frame containing the environmental data (i.e. precipitation, temperature, PM10, etc.) with the following variables: \code{lon, lat, time, value, anom_value}. See \code{tidy_nc}.}

\item{clas}{data.frame. A data.frame of the synoptic classification (time and WT) obtained from the \code{synoptclas} function.}

\item{fun}{function. A function to be applied to the environmental variable for each WT.}

\item{out}{character. Choose between \code{"data.frame"} (default) or \code{"raster"} A function to be applied to the environmental variable for each WT.}
}
\value{
a data.frame or a Raster Stack containing the environmental grids based on the weather types.
}
\description{
This function applies the approach: "circulation types to environment".
}
\examples{
# Load data (mslp or precp_grid)
data(mslp)
data(z500)
# Tidying our atmospheric variables (500 hPa geopotential height
# and mean sea level pressure) together.

# Time subset between two dates
atm_data1 <- tidy_nc(x = list(mslp,z500),
             name_vars = c("mslp","z500"))

# S-mode classification
smode_clas <- synoptclas(atm_data1, ncomp = 6)

# ct2env (precipitation example)
ct2env(x = pcp, clas = smode_clas$clas, fun = mean, out = "data.frame")


}
