/*
 * Decompiled with CFR 0.152.
 */
package sample;

public class DuoNodes {
    private static final double loadFactor = 0.75;
    private int size = 0;
    private int maxSize = 1024;
    private int rehashThreshold = (int)(0.75 * (double)this.maxSize);
    private int[] index = new int[this.maxSize];
    private int[] nodeAB1 = new int[this.maxSize];
    private int[] nodeA2 = new int[this.maxSize];
    private int[] nodeB2 = new int[this.maxSize];
    private double[] value = new double[this.maxSize];

    private static int hash1(int n, int n2, int n3) {
        int n4 = 5;
        n4 = 71 * n4 + n;
        n4 = 71 * n4 + n2;
        n4 = 71 * n4 + n3;
        return n4;
    }

    private static int hash2(int n, int n2, int n3) {
        int n4 = 7;
        n4 = 97 * n4 + n;
        n4 = 97 * n4 + n2;
        n4 = 97 * n4 + n3;
        return n4;
    }

    private int index(int n, int n2, int n3) {
        int n4 = DuoNodes.hash1(n, n2, n3);
        int n5 = DuoNodes.hash2(n, n2, n3);
        if ((n5 & 1) == 0) {
            ++n5;
        }
        for (int i = 0; i < this.maxSize; ++i) {
            int n6 = (n4 + i * n5) % this.maxSize;
            if (n6 < 0) {
                n6 = -n6;
            }
            if (this.value[n6] != 0.0 && (this.nodeAB1[n6] != n || this.nodeA2[n6] != n2 || this.nodeB2[n6] != n3)) continue;
            return n6;
        }
        assert (false);
        return -1;
    }

    private void rehash() {
        assert (this.size >= this.rehashThreshold);
        int n = 2 * this.maxSize;
        if (n < 0) {
            throw new IllegalStateException("hash table overflow");
        }
        int[] nArray = this.index;
        int[] nArray2 = this.nodeAB1;
        int[] nArray3 = this.nodeA2;
        int[] nArray4 = this.nodeB2;
        double[] dArray = this.value;
        this.maxSize = n;
        this.index = new int[n];
        this.nodeAB1 = new int[n];
        this.nodeA2 = new int[n];
        this.nodeB2 = new int[n];
        this.value = new double[n];
        for (int i = 0; i < this.size; ++i) {
            int n2;
            int n3 = nArray[i];
            this.index[i] = n2 = this.index(nArray2[n3], nArray3[n3], nArray4[n3]);
            this.nodeAB1[n2] = nArray2[n3];
            this.nodeA2[n2] = nArray3[n3];
            this.nodeB2[n2] = nArray4[n3];
            this.value[n2] = dArray[n3];
        }
        this.rehashThreshold = (int)(0.75 * (double)this.maxSize);
    }

    public void maxUpdate(int n, int n2, int n3, double d) {
        if (d > 0.0) {
            int n4 = this.index(n, n2, n3);
            if (this.value[n4] > 0.0) {
                if (d > this.value[n4]) {
                    this.value[n4] = d;
                }
            } else {
                this.index[this.size++] = n4;
                this.nodeAB1[n4] = n;
                this.nodeA2[n4] = n2;
                this.nodeB2[n4] = n3;
                this.value[n4] = d;
                if (this.size >= this.rehashThreshold) {
                    this.rehash();
                }
            }
        } else if (!(d >= 0.0)) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
    }

    public void sumUpdate(int n, int n2, int n3, double d) {
        if (d > 0.0) {
            int n4 = this.index(n, n2, n3);
            if (this.value[n4] > 0.0) {
                int n5 = n4;
                this.value[n5] = this.value[n5] + d;
            } else {
                this.index[this.size++] = n4;
                this.nodeAB1[n4] = n;
                this.nodeA2[n4] = n2;
                this.nodeB2[n4] = n3;
                int n6 = n4;
                this.value[n6] = this.value[n6] + d;
                if (this.size >= this.rehashThreshold) {
                    this.rehash();
                }
            }
        } else if (!(d >= 0.0)) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
    }

    public void trim(double d) {
        if (d <= 0.0 || Double.isNaN(d)) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
        double d2 = 0.0;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.value[this.index[i]] > d2)) continue;
            d2 = this.value[this.index[i]];
        }
        double d3 = d2 / d;
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.value[this.index[i]] < d3) {
                this.value[this.index[i]] = 0.0;
                continue;
            }
            this.index[n++] = this.index[i];
        }
        this.size = n;
    }

    public int size() {
        return this.size;
    }

    private void checkSize(int n) {
        if (n >= this.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
    }

    public int enumNodeAB1(int n) {
        this.checkSize(n);
        return this.nodeAB1[this.index[n]];
    }

    public int enumNodeA2(int n) {
        this.checkSize(n);
        return this.nodeA2[this.index[n]];
    }

    public int enumNodeB2(int n) {
        this.checkSize(n);
        return this.nodeB2[this.index[n]];
    }

    public double enumValue(int n) {
        this.checkSize(n);
        return this.value[this.index[n]];
    }

    public double value(int n, int n2, int n3) {
        return this.value[this.index(n, n2, n3)];
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.value[this.index[i]] = 0.0;
        }
        this.size = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("size=");
        stringBuilder.append(this.size);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(" (");
            stringBuilder.append(i);
            stringBuilder.append(": nodeAB1=");
            stringBuilder.append(this.enumNodeAB1(i));
            stringBuilder.append(" nodeA2=");
            stringBuilder.append(this.enumNodeA2(i));
            stringBuilder.append(" nodeB2=");
            stringBuilder.append(this.enumNodeB2(i));
            stringBuilder.append(" value=");
            stringBuilder.append(this.enumValue(i));
            stringBuilder.append(") ");
        }
        return stringBuilder.toString();
    }
}

