/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.Filter;
import java.util.Collection;
import java.util.HashSet;

public final class FilterUtils {
    private FilterUtils() {
    }

    public static <E> Filter<E> acceptAllFilter() {
        return new Filter<E>(){

            @Override
            public boolean accept(E e) {
                if (e == null) {
                    throw new NullPointerException("e==null");
                }
                return true;
            }
        };
    }

    public static <E> Filter<E> singletonFilter(final E e) {
        if (e == null) {
            throw new NullPointerException("singleton==null");
        }
        return new Filter<E>(){

            @Override
            public boolean accept(E e2) {
                if (e2 == null) {
                    throw new NullPointerException("e==null");
                }
                return e.equals(e2);
            }
        };
    }

    public static <E> Filter<E> includeFilter(Collection<E> collection) {
        final HashSet<E> hashSet = new HashSet<E>(collection);
        return new Filter<E>(){

            @Override
            public boolean accept(E e) {
                if (e == null) {
                    throw new NullPointerException("e==null");
                }
                return hashSet.contains(e);
            }
        };
    }

    public static <E> Filter<E> excludeFilter(Collection<E> collection) {
        final HashSet<E> hashSet = new HashSet<E>(collection);
        return new Filter<E>(){

            @Override
            public boolean accept(E e) {
                if (e == null) {
                    throw new NullPointerException("e==null");
                }
                return !hashSet.contains(e);
            }
        };
    }

    public static <E> Filter<E> includeExcludeFilter(Collection<E> collection, Collection<E> collection2) {
        final HashSet<E> hashSet = new HashSet<E>(collection);
        final HashSet<E> hashSet2 = new HashSet<E>(collection2);
        return new Filter<E>(){

            @Override
            public boolean accept(E e) {
                if (e == null) {
                    throw new NullPointerException("e==null");
                }
                return hashSet.contains(e) && !hashSet2.contains(e);
            }
        };
    }
}

