/*
 * Decompiled with CFR 0.152.
 */
package beagleutil;

import beagleutil.ChromIds;
import beagleutil.IntInterval;
import vcf.Marker;

public final class ChromInterval
implements IntInterval,
Comparable<ChromInterval> {
    private final int chromIndex;
    private final int start;
    private final int end;

    public ChromInterval(Marker marker, Marker marker2) {
        if (marker.chromIndex() != marker2.chromIndex()) {
            String string = "start.chromIndex() != end.chromIndex()";
            throw new IllegalArgumentException(string);
        }
        if (marker.pos() < 0 || marker.pos() > marker2.pos()) {
            String string = "start=" + marker + " end=" + marker2;
            throw new IllegalArgumentException(string);
        }
        this.chromIndex = marker.chromIndex();
        this.start = marker.pos();
        this.end = marker2.pos();
    }

    public ChromInterval(String string, int n, int n2) {
        if (n < 0 || n > n2) {
            String string2 = "start=" + n + " end=" + n2;
            throw new IllegalArgumentException(string2);
        }
        this.chromIndex = ChromIds.instance().indexOf(string);
        this.start = n;
        this.end = n2;
    }

    public static ChromInterval parse(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        int n = string.length();
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        int n4 = string.lastIndexOf(58);
        int n5 = string.lastIndexOf(45);
        if (n == 0) {
            return null;
        }
        if (n4 == -1) {
            return new ChromInterval(string, n2, n3);
        }
        if (n4 == n - 1) {
            return new ChromInterval(string.substring(0, n - 1), n2, n3);
        }
        if (n5 == -1 || n5 <= n4 || n4 == n - 2 || !ChromInterval.isValidPos(string, n4 + 1, n5) || !ChromInterval.isValidPos(string, n5 + 1, n)) {
            return null;
        }
        if (n5 > n4 + 1) {
            n2 = Integer.parseInt(string.substring(n4 + 1, n5));
        }
        if (n > n5 + 1) {
            n3 = Integer.parseInt(string.substring(n5 + 1, n));
        }
        if (n2 < 0 || n2 > n3) {
            return null;
        }
        return new ChromInterval(string.substring(0, n4), n2, n3);
    }

    private static boolean isValidPos(String string, int n, int n2) {
        if (n == n2) {
            return true;
        }
        int n3 = n2 - n;
        if (n3 > 1 && string.charAt(n) == '\u0000') {
            return false;
        }
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public int chromIndex() {
        return this.chromIndex;
    }

    public String chrom() {
        return ChromIds.instance().id(this.chromIndex);
    }

    @Override
    public int start() {
        return this.start;
    }

    @Override
    public int end() {
        return this.end;
    }

    @Override
    public int compareTo(ChromInterval chromInterval) {
        if (this.chromIndex != chromInterval.chromIndex) {
            return this.chromIndex < chromInterval.chromIndex ? -1 : 1;
        }
        if (this.start != chromInterval.start) {
            return this.start < chromInterval.start ? -1 : 1;
        }
        if (this.end != chromInterval.end) {
            return this.end < chromInterval.end ? -1 : 1;
        }
        return 0;
    }

    public int hashCode() {
        int n = 7;
        n = 67 * n + this.chromIndex;
        n = 67 * n + this.start;
        n = 67 * n + this.end;
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChromInterval chromInterval = (ChromInterval)object;
        if (this.chromIndex != chromInterval.chromIndex) {
            return false;
        }
        if (this.start != chromInterval.start) {
            return false;
        }
        return this.end == chromInterval.end;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ChromIds.instance().id(this.chromIndex));
        stringBuilder.append(':');
        stringBuilder.append(this.start);
        stringBuilder.append('-');
        stringBuilder.append(this.end);
        return stringBuilder.toString();
    }

    public static boolean overlap(ChromInterval chromInterval, ChromInterval chromInterval2) {
        if (chromInterval.chromIndex() != chromInterval2.chromIndex()) {
            return false;
        }
        return chromInterval.start() <= chromInterval2.end() && chromInterval2.start() <= chromInterval.end();
    }

    public static ChromInterval merge(ChromInterval chromInterval, ChromInterval chromInterval2) {
        if (!ChromInterval.overlap(chromInterval, chromInterval2)) {
            String string = "non-overlappng intervals: " + chromInterval + " " + chromInterval2;
            throw new IllegalArgumentException(string);
        }
        int n = Math.min(chromInterval.start(), chromInterval2.start());
        int n2 = Math.max(chromInterval.end(), chromInterval2.end());
        return new ChromInterval(chromInterval.chrom(), n, n2);
    }
}

