% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_performance_multiple.R
\name{plot_performance_multiple}
\alias{plot_performance_multiple}
\title{plot_performance_multiple}
\usage{
plot_performance_multiple(
  data,
  triagelevel_correct,
  triagelevel_advice,
  order_triagelevel,
  vector_not_entered,
  vignettes,
  apps
)
}
\arguments{
\item{data}{A dataframe}

\item{triagelevel_correct}{A string indicating the column name storing the correct triage solutions}

\item{triagelevel_advice}{A string indicating the column name storing the recommendation of a symptom checker for a case}

\item{order_triagelevel}{A vector indicating the order of triage levels. The triage level with highest urgency should be the first value and the triage level with lowest urgency the last value.}

\item{vector_not_entered}{A vector indicating the values in which missing values are coded (e.g., as NA or a specified value such as -99)}

\item{vignettes}{A string indicating the column name storing the vignette or vignette number}

\item{apps}{A string indicating the column name storing the app names}
}
\value{
A ggplot object visualizing all performance metrics for all symptom checkers in dataframe
}
\description{
Plots the all performance metrics for all symptom checkers in dataframe
}
\examples{
data(symptomcheckRdata)
performance_plot <- plot_performance_multiple(
  data = symptomcheckRdata,
  triagelevel_correct = "Goldstandard_solution",
  triagelevel_advice = "Triage_advice_from_app",
  order_triagelevel = c("Emergency", "Non-Emergency", "Self-care"),
  vector_not_entered = c(NA),
  vignettes = "Vignette_id",
  apps = "App_name"
  )

}
