% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_vector_by.R
\name{sum_vector_by}
\alias{sum_vector_by}
\title{Vector Syllable Sums By Grouping Variable(s)}
\usage{
sum_vector_by(x, group, as.tibble = tibble_output(), ...)
}
\arguments{
\item{x}{A character vector.}

\item{group}{The grouping variable(s).  Takes a single grouping variable or a list
of 1 or more grouping variables.}

\item{as.tibble}{logical.  If \code{TRUE} the output class will be set to a
\pkg{tibble}, otherwise a \code{\link[data.table]{data.table}}.  Default
checks \code{getOption("tibble.out")} as a logical.  If this is \code{NULL}
the default \code{\link[textshape]{tibble_output}} will set \code{as.tibble}
to \code{TRUE} if \pkg{dplyr} is loaded.  Otherwise, the output will be a
\code{\link[data.table]{data.table}}.}

\item{\ldots}{ignored.}
}
\value{
Returns a \code{\link[base]{data.frame}} (\code{\link[data.table]{data.table}}) of
syllable sums (count) by grouping variable.
}
\description{
Syllable sums for the words in the vectors of strings by grouping variables.
}
\examples{
dat <- data.frame(
   text = c("I like chicken.", "I want eggs Benedict for breakfast.", "Really?"),
   group = c("A", "B", "A")
)
sum_vector_by(dat$text, dat$group)

with(presidential_debates_2012, sum_vector_by(dialogue, list(person, time)))
}
\seealso{
Other syllable.functions: \code{\link{count_string}},
  \code{\link{count_vector_by}},
  \code{\link{count_vector}}, \code{\link{sum_string}},
  \code{\link{sum_vector}},
  \code{\link{tally_both_string}},
  \code{\link{tally_both_vector_by}},
  \code{\link{tally_both_vector}},
  \code{\link{tally_di_string}},
  \code{\link{tally_di_vector_by}},
  \code{\link{tally_di_vector}},
  \code{\link{tally_mono_string}},
  \code{\link{tally_mono_vector_by}},
  \code{\link{tally_mono_vector}},
  \code{\link{tally_poly_string}},
  \code{\link{tally_poly_vector_by}},
  \code{\link{tally_poly_vector}},
  \code{\link{tally_short_string}},
  \code{\link{tally_short_vector_by}},
  \code{\link{tally_short_vector}}
}

