% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_vector_by.R
\name{count_vector_by}
\alias{count_vector_by}
\title{Vector Syllable Counts By Grouping Variable(s)}
\usage{
count_vector_by(x, group, ...)
}
\arguments{
\item{x}{A character vector.}

\item{group}{The grouping variable(s).  Takes a single grouping variable or a list
of 1 or more grouping variables.}

\item{\ldots}{ignored.}
}
\value{
Returns a named list of vectors of integer counts for each grouping variable.
}
\description{
Syllable counts for the words in a vector of strings by grouping variables.
}
\examples{
dat <- data.frame(
   text = c("I like chicken.", "I want eggs Benedict for breakfast.", "Really?"),
   group = c("A", "B", "A")
)
count_vector_by(dat$text, dat$group)

with(presidential_debates_2012, count_vector_by(dialogue, list(person, time)))
}
\seealso{
Other syllable.functions: \code{\link{count_string}},
  \code{\link{count_vector}}, \code{\link{sum_string}},
  \code{\link{sum_vector_by}}, \code{\link{sum_vector}},
  \code{\link{tally_both_string}},
  \code{\link{tally_both_vector_by}},
  \code{\link{tally_both_vector}},
  \code{\link{tally_di_string}},
  \code{\link{tally_di_vector_by}},
  \code{\link{tally_di_vector}},
  \code{\link{tally_mono_string}},
  \code{\link{tally_mono_vector_by}},
  \code{\link{tally_mono_vector}},
  \code{\link{tally_poly_string}},
  \code{\link{tally_poly_vector_by}},
  \code{\link{tally_poly_vector}},
  \code{\link{tally_short_string}},
  \code{\link{tally_short_vector_by}},
  \code{\link{tally_short_vector}}
}

