%% SyBiL Version History

\name{NEWS}
\title{SyBiL News}
\encoding{UTF-8}

\newcommand{\CRANpkg}{\href{http://CRAN.R-project.org/package=#1}{\pkg{#1}}}

% ---------------------------------------------------------------------------- %
\section{Changes in version 1.0.2 2012-04-20}{
  \itemize{
    \item renamed parameter \code{SOLVER_CTRL_PARAM} to \code{SOLVER_CTRL_PARM}
    \item renamed argument \code{param} in \code{SYBIL_SETTINGS()} to
          \code{parm}
    \item file \file{NEWS} is now in \file{inst/NEWS.Rd}
    \item added argument \code{absCtrl} to the \code{plot} method in
          class \code{optsol_robAna}
    \item in \code{readTSVmod}, if a model description file is missing, the
          basename of the reaction list is used as model id, not the complete
          path to the file if fpath is used, or the reaction list is not in
          the working directory
    \item removed arguments \code{verboseMode}, \code{loglevel}, \code{logfile}
          and \code{logfileEnc} from function \code{readTSVmod}; use function
          \code{sink} instead
    \item removed arguments \code{loglevel}, \code{logfile} and
          \code{logfileEnc} from function \code{optimizer}; use function
          \code{sink} instead
    \item added method \code{show} to class \code{sybilError}
    \item methods \code{logOptimization} and \code{logOptimizationNE} of class
          \code{sybilLog} need argument \code{i} giving a consecutive number
    \item methods \code{logComment}, \code{logOptimization},
          \code{logOptimizationNE} and \code{logOptimizationTH} of class
          \code{sybilLog} now also write to \code{stdout} (by \code{cat}) if
          \code{verblevel} is \code{> 2}
    \item fixed a bug in \code{mod2irrev()}: slots \code{met_de} and
          \code{react_de} of class \code{modelorg} (in the reversible model)
          are no longer ignored
    \item added function \code{addReact()} to add or change reactions in a
          given model
    \item added function \code{addExchReact()} to add exchange reactions for
          metabolites to a given model
    \item minor changes in \code{printObjFunc()}
    \item SYBIL_SETTINGS(parm) gives an error if \code{parm} is not a valid
          parameter name
    \item function \code{findExchReact()} now returns indices of metabolite id's
          having an exchange reaction
    \item compatible to \CRANpkg{clpAPI} (version \eqn{\geq}{>=} 1.2.0)
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 1.0.1 2012-03-16}{
  \itemize{
    \item removed \pkg{sybilSBML} from Suggests field and removed undocumented
          function \code{readModel()}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 1.0.0 2012-03-16}{
  \itemize{
    \item added method \code{dim} to class \code{modelorg}

    \item renamed method \code{setColsBndsObjCoefs} to
          \code{changeColsBndsObjCoefs}

    \item updated documentation

    \item depends on \CRANpkg{glpkAPI} (version \eqn{\geq}{>=} 1.2.1)

    \item needs \CRANpkg{cplexAPI} (version \eqn{\geq}{>=} 1.2.0)

    \item switched from \CRANpkg{SparseM} to \CRANpkg{Matrix}
          (version \eqn{\geq}{>=} 1.0-4), a consequence is a dependency on R
          (version \eqn{\geq}{>=} 2.12.0)

    \item completely new implementation of \code{SYBIL_SETTINGS}

    \item reorganization of files: one class \eqn{\rightarrow}{>=} one file

    \item use Collate field in file \file{DESCRIPTION}

    \item LIFO/FIFO (stack/queue) implementation with new functions \cr
          \code{stinit()}, \code{stclear()}, \code{stpush()},
          \code{stpop()}, \cr
          \code{stunshift()}, \code{stshift()}, \code{stseek()},
          \code{stfirst()}, \cr
          \code{stlist()}, \code{stlength()} and \code{stexists()}

    \item a few compatibility changes in \code{readTSVmod()} for output of
          \href{http://bigg.ucsd.edu/}{BiGG database}: added arguments
          \code{quoteChar}, \code{commentChar} and \code{oneSubSystem}

    \item added argument \code{minimalSet} to \code{modelorg2tsv()}

    \item added function \code{geneDeletion()} for \eqn{n} gene deletions

    \item fixed a bug in \code{doubleGeneDel()} when \code{allComb = FALSE}

    \item added \code{geneDeletion} to \code{multiDel()}

    \item added argument \code{checkId} to \code{geneDel()}

    \item arguments \code{poCmd} and \code{prCmd} to \code{optimizer} and
          \code{simpleFBA} must be of type \code{list}

    \item some improvements in \code{sybilLogClass}

    \item \code{optimizer()} now makes use of class \code{sybilLog}

    \item removed arguments \code{resolve} and \code{resolveParm} from
          \code{optimizer()}

    \item removed \pkg{SyBiL} parameters \code{LP_ALT_METHOD} and \cr
          \code{SOLVER_ALT_CTRL_PARAM} from \code{SYBIL_SETTINGS()}

    \item renamed \pkg{SyBiL} parameter \code{LP_SOLVER to SOLVER}

    \item renamed \pkg{SyBiL} parameter \code{LP_METHOD to METHOD}

    \item moved methods \code{length} and \code{hist} from class
          \code{optsol_fluxdel} to class \code{optsol}

    \item added slot num_of_prob in class checksol

    \item fixed a bug in class \code{optObj} when setting parameters to
          \CRANpkg{lpSolveAPI}

    \item added arguments \code{connect} and \code{colconnect} to the
          \code{plot} mathod of class \code{optsol_fluxVar}

    \item updated package vignette
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.5.11 2011-12-12}{
  \itemize{
    \item fixed a bug in \code{readTSVmod()} when reading closed networks

    \item \code{.createReactionString()} now adds the compartment id to the
          metabolite id if it is not already there

    \item if the metabolite id's do not contain the compartment abbreviation in
          square brackets, the compartment names are used by
          \code{modelorg2tsv()}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.5.10 2011-12-09}{
  \itemize{
    \item added arguments \code{exclM} and \code{exclR} to
          \code{.singletonMetabolite()}

    \item in \code{readTSVmod()}: upper and lower bounds which are larger
          than \code{abs(def_bnd)} are set to \code{abs(def_bnd)}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.5.9 2011-08-30}{
  \itemize{
    \item added slots \code{met_de} and \code{react_de} to \code{modelorg}

    \item added boolean arguments \code{remMet}, \code{contrMet},
          \code{singletonMet} and \code{deadEndmet} to \code{readTSVmod()}, the
          two boolean arguments \code{remSingleMet} and \code{constrSingleMet}
          are removed, see \code{help("readTSVmod")} for details
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.5.8 2011-08-22}{
  \itemize{
    \item fixed a bug in constructor of class \code{sybilError}

    \item depends on \CRANpkg{cplexAPI} (version \eqn{\geq}{>=} 1.1.7)

    \item \code{checkOptSol()} is compatible with \CRANpkg{cplexAPI}
          (version 1.1.7) in combination with IBM ILOG CPLEX (version 12.3)
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.5.7 2011-08-15}{
  \itemize{
    \item slots \code{met_single} and \code{react_single} of class
          \code{modelorg} are initialized with \code{NA}, not \code{FALSE}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.5.6 2011-08-15}{
  \itemize{
    \item some minor changes in \code{readTSVmod()} according to
          \CRANpkg{codetools}

    \item fixed a bug in class \code{logFileFH}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.5.5 2011-08-12}{
  \itemize{
    \item added slots \code{met_single} and \code{react_single} to class
          \code{modelorg}

    \item new arguments for \code{readTSVmod()}:
          \code{mergeMet}, \code{balanceReact}, \code{remUnusedMetReact},
          \code{remSingleMet}, \code{constrSingleMet} and \code{tol} see
          \code{help("readTSVmod")} for details
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.5.4 2011-08-08}{
  \itemize{
    \item method \code{logError} of class \code{sybilLog} returns object of
          class \code{sybilError}

    \item fixed a bug in \code{.printNamedList()}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.5.3 2011-08-05}{
  \itemize{
    \item added class \code{sybilLog}

    \item added logging in \code{readTSVmod()}, see \code{help("readTSVmod")}
          for details and new arguments
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.5.2 2011-07-29}{
  \itemize{
    \item added \code{NAMESPACE}

    \item fixed a minor bug in \code{findExchReact()}
    \item fixed a bug in method \code{show} for class \code{SYBIL_SETTINGS}
    \item fixed a bug in \code{.validModelorg()}

    \item changes in \code{readTSVmod()}:
      \itemize{
        \item If a metabolite is used more than once as product or
        educt of a particular reaction, it is merged:
        \preformatted{a + (2) a}
        is converted to
        \preformatted{(3) a}
        and a warning will be given.

        \item If a metabolite is used first as educt and then as
        product of a particular reaction, the reaction is
        balanced:
        \preformatted{(2) b + a -> b + c}
        is converted to
        \preformatted{    b + a ->     c}

        \item The stoichiometric matrix S is scanned for metabolites, which are
              used only once in S. If there are some, a warning will be given.

        \item The stoichiometric matrix S is scanned for reactions, which are
              not used in S. If there are some, a warning will be given and the
              corresponding reactions will be removed from the model.

        \item Some improvements in parsing the reaction string: if more than one
              reaction arrow is found, a warning is given and the reaction will
              be removed from the model.
    }
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.5.1 2011-07-12}{
  \itemize{
    \item support for low level interface \CRANpkg{glpkAPI} (version 1.1.2)
    \item support for low level interface \CRANpkg{clpAPI} (version 1.1.1)
    \item support for low level interface \CRANpkg{cplexAPI} (version 1.1.1)

    \item added new slot in class \code{optObj}: \code{probType}.
          The constructor function \code{optObj()} has a new argument
          \code{pType}, with \code{lp} as default value (linear programming).
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.5.0 2011-05-20}{
  \itemize{
    \item updated documentation
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.4.1 2011-05-18}{
  \itemize{
    \item slot \code{subSys} in class \code{modelorg} is now of class
          \code{matrix}, so one reaction can belong to more than one subsystem,
          for example:
          \tabular{llll}{
                       \tab \code{cytosol} \tab  \code{mitochondria} \tab  \code{external} \cr
            \code{v_1} \tab \code{TRUE}    \tab  \code{FALSE}        \tab  \code{FALSE}    \cr
            \code{v_2} \tab \code{TRUE}    \tab  \code{TRUE}         \tab  \code{FALSE}    \cr
            \code{v_3} \tab \code{FALSE}   \tab  \code{TRUE}         \tab  \code{FALSE}    \cr
            \code{b_1} \tab \code{FALSE}   \tab  \code{FALSE}        \tab  \code{TRUE}     \cr
            \code{b_2} \tab \code{FALSE}   \tab  \code{FALSE}        \tab  \code{TRUE}     \cr
          }
          In slot \code{subSys}, only the column names are named according to
          the subsystem. The rows do not have names, the first row corresponds
          to the first reaction in slot \code{react_id}, the second row to the
          second reaction id, and so forth.

    \item added method \code{getRedCost} to class \code{optObj}.
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.4.0 2011-03-01}{
  \itemize{
    \item SBML compatibility is moved to the package \pkg{sybilSBML}, making
          \pkg{SyBiL} independend from rsbml. The new package \pkg{sybilSBML}
          requires a working \pkg{rsbml} installation (available from
          \href{http://www.bioconductor.org/}{Bioconductor}).

    \item added functions \code{modelorg2tsv()} and \code{readTSVmod()} in order
          to handle \file{tsv} files compatible to the
          \href{http://bigg.ucsd.edu/}{BiGG database}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.3.6 2010-12-16}{
  \itemize{
    \item fixed a bug in \code{optimizer()} when pre/post-processing
          should be performed, but no optimization was done.
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.3.5 2010-12-15}{
  \itemize{
    \item added argument \code{solverParm} in \code{fluxVar()}, argument
          \code{...} is passed to \code{simpleFBA()} now

    \item cleaning of class \code{optObj}:
    \itemize{
      \item new classes extending \code{optObj}:
            \code{optObj_glpk}, \code{optObj_clp}, \code{optObj_cplex}
            and \code{optObj_lpSolveAPI}

      \item methods \code{setRhsZero} and \code{setColsBndsObjCoefs} are not
            usable for initial model creation (this is a feature, not a bug).
            Use \code{addRows} and \code{addCols} here.
    }

    \item added stack like functions
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.3.4 2010-11-05}{
  \itemize{

    \item added function \code{multiDel()}: \code{multicore} support for
          \code{oneGeneDel()}, \code{doubleGeneDel()}, \code{oneFluxDel()}
          and \code{doubleFluxDel()}

    \item fixed a bug in \code{fluxVar()}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.3.3 2010-09-28}{
  \itemize{
    \item removed file \file{NAMESPACE}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.3.2 2010-09-22}{
  \itemize{
    \item blockedReact() now works also for irreversible models.
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.3.1 2010-09-14}{
  \itemize{
    \item some improvements in \code{readSBMLmod()}

    \item depends on \pkg{rsbml} version \eqn{\geq}{>=} 2.4.0
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.3.0 2010-08-20}{
  \itemize{
    \item first public beta release
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.2.8 2010-08-07}{
  \itemize{
    \item some things were renamed:
      \itemize{
        \item class \code{postAnalysis} is now class \code{ppProc}
        \item function \code{postProcessing()} is now function
              \code{.ppProcessing()}
        \item slot \code{postAna} in class \code{optsol_simpleFBA} is now
              slot \code{postProc}
        \item argument \code{ppCmd} in function \code{simpleFBA()} is now
              argument \code{poCmd}
      }

    \item added slot \code{preProc} in class \code{optsol_simpleFBA()}

    \item added argument \code{prCmd} in function \code{simpleFBA()}:
          same purpose as argument \code{poCmd}, but the commands are
          executed immideately before solving the optimization problem.
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.2.7 2010-08-06}{
  \itemize{
    \item added slot \code{lethal} to class \code{optsol_doublefluxdel}

    \item added method \code{ind2id()} to class \code{optsol_fluxdel},
          \code{optsol_genedel} and \code{optsol_doublegenedel}

    \item some minor improvements in \code{doubleGeneDel()}

    \item added classes \code{sybilError} and \code{postAnalysis}

    \item added function \code{postProcessing()}

    \item added slot \code{postAna} in class \code{optsol_simpleFBA}

    \item added method \code{sensitivityAnalysis} in class \code{optObj}

    \item added argument \code{ppCmd} in \code{simpleFBA()}:

      The argument \code{ppCmd} should be a character vector. If it has a
      length \eqn{=} 1, it will be treated as a function name, if it has
      length \eqn{>} 1, it will be treated as function name (\code{ppCmd[1]})
      plus arguments (\code{ppCmd[-1]}).  Basically, \code{ppCmd} is treated as
      a command, executed on the problem object (object of class \code{optObj}),
      after the problem has been solved.  The first element of \code{ppCmd} will
      be used as function name, all other elements as arguments to that
      function. The command will be joint with \code{\sQuote{,}} and
      \code{\sQuote{()}}:
      \preformatted{
ppCmd[1] "(" ppCmd[-1] ")"
      }
      and \code{ppCmd[-1]} will be joind with \code{\sQuote{,}}.
    
      The string \code{\dQuote{LP_PROB}} will be used as a placeholder for the
      variable name of the problem object. If \code{\dQuote{LP_PROB}} is used
      in \code{ppCmd}, it will be replaced.  The result of the execution of
      \code{ppCmd} will be stored in an object of class \code{postAnalysis}
      in the slot \code{postAna} of class \code{optsol_simpleFBA}.
    
      Some examples:
      \itemize{
        \item perform sensitivity analysis with GLPK:
        \preformatted{
simpleFBA(<model>, ppCmd = "sensitivityAnalysis")
        }
        Here, \code{ppCmd} has length \eqn{=} 1,
        \code{\dQuote{sensitivityAnalysis}} will be treated as a function name
        and executed on the problem object.

        \item access reduced costs in conjunction with IBM ILOG CPLEX:
        \preformatted{
simpleFBA(<model>, solver = "cplex",
          ppCmd = c("getDjCPLEX",
                    "LP_PROB@oobj$env", "LP_PROB@oobj$lp",
                    "0", "react_num(<model>)-1"))
        }
        In that example, \code{ppCmd} has length \eqn{>} 1, the first element
        is the function name, the others are the arguments.  For IBM ILOG CPLEX,
        slot \code{oobj} of objects of class \code{optObj} is a list,
        containing a pointer to the cplex environment \code{env} and a second
        pointer to the problem object \code{lp}.  The third and fourth argument
        are \code{begin} and \code{end} for the function \code{getDjCPLEX()}.
        Remember: in IBM ILOG CPLEX, the first element has index 0!
      }
      
      Instances of class \code{postAnalysis} have two slots:
      \describe{
        \item{cmd}{a single character string containing the executed command}
        \item{pa}{the result of the post processing. If an error occured,
                  \code{pa} contains the error message and is of class
                  \code{sybilError}}
      }
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.2.6 2010-06-30}{
  \itemize{
    \item fixed a bug in \code{optimizer()}:
          flux distribution was not saved when argument \code{rebuildModel} is
          set to \code{TRUE} and the used algorithm is
          \code{\dQuote{linearMOMA}}

    \item option \code{resolve = TRUE} in \code{optimizer()} is working again.

    \item setting of parameters to lp solver with \code{SYBIL_SETTINGS} is
          working again.

    \item improved function \code{blockedReact()}.
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.2.5 2010-06-22}{
  \itemize{
    \item fixed a bug in \code{changeObjCoefs()}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.2.4 2010-05-19}{
  \itemize{
    \item fixed a bug in \code{onlyChangeGPR()}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.2.3 2010-05-17}{
  \itemize{
    \item fixed a bug in \code{changeGPR()}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.2.2 2010-05-12}{
  \itemize{
    \item added function \code{changeGPR()}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.2.1 2010-04-28}{
  \itemize{
    \item fixed a small bug in \code{readSBMLmod()}

    \item fixed a bug in \code{optimizer()} in conjunction with IBM ILOG CPLEX
          and parameter \code{copyModel = TRUE}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.2.0 2010-04-26}{
  \itemize{
    \item fixed a bug in \code{optObj_Class}:
          \code{loadProblemDataML()} produced an error when
          \code{solver = "lpSolveAPI"} and \code{alg = "linearMOMA_COBRA"}

    \item method \code{loadProblemDataMTF} in \code{optObj_Class} failed when
          IBM ILOG CPLEX is used

    \item fixed a bug in \code{mod2irrev()}: slot \code{rev2irrev} contained
          wrong entries.
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.1.9 2010-02-28}{
  \itemize{
    \item argument \code{resolve} in \code{optimizer()} is not working in this
          version!

    \item completely rewritten function \code{simpleFBA()}; new (changed)
          arguments:
      \describe{
        \item{react}{(default: \code{NA}) fluxes with changed lower and upper
          bounds}
        \item{lb}{(default: \code{NA}) new lower bounds for fluxes in argument
          \code{react}}
        \item{ub}{(default: \code{NA}) new upper bounds for fluxes in argument
          \code{react}}
        \item{minTotalFlux}{(default: \code{FALSE}) boolean, if set to
          \code{TRUE}, after FBA, the sum of all flux rates will be minimized}
        \item{minDist}{(default: \code{FALSE}) boolean, if set to \code{TRUE},
          a minimized distance to a wild type flux distribution will be
          generated}
        \item{wtFluxes}{(default: \code{NA}) a single flux value (if
          argument \code{minTotalFlux} is set to \code{TRUE}) for on optimized
          objective function, or a flux vector (if argument \code{minDist} is
          set to \code{TRUE}) for an optimized flux distribution.
          If \code{wtFluxes} is \code{NA}, FBA will be performed. If arguments
          \code{minDist} or \code{minTotalFlux} are TRUE and \code{wtFluxes} is
          \code{NA}, the needed values will be calculated by FBA.}
      }

    \item added method \code{backupProb()} in class \code{optObj}:
      \describe{
        \item{glpk/cplex}{the functions
          \code{copyProbGLPK()}/\code{cloneProbCPLEX()} will be used here, which
          return a pointer to the new problem object}
        \item{clp/lpSolveAPI}{the functions
          \code{saveModelCLP()}/\code{write.lp()} will be used here, which write
          the specified problem to file. That file will be deleted after
          building the new problem out of those. That may cause a lot IO.}
      }
    \item new arguments to \code{optimizer()} [can be passed to
          \code{optimizer()} by argument \code{...} in e.g. \code{oneGeneDel()}
          or \code{doubleGeneDel()}]:
      \describe{
        \item{rebuildModel}{(default: \code{FALSE}) boolean. If set to
          \code{TRUE}, the problem object will be recreated for every
          optimization.  That will increase the running time significantly!}
        \item{copyModel}{(default: \code{FALSE}) boolean. If set to \code{TRUE},
          the problem object will be taken from a backup copy. That backup copy
          will be created prior to the very first optimization from the modelorg
          object.}
      }
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.1.8 2010-01-17}{
  \itemize{
    \item argument \code{alg} in \code{optimizer()} works now for all solvers
    \item added the used algorithm in the logfile
    \item added dependency on \CRANpkg{SparseM}
    \item added options \code{exLethal} and \code{tol} to \code{doubleGeneDel()}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.1.7 2009-12-07}{
  \itemize{
    \item argument \code{alg} in \code{optimizer()}: can be \code{\dQuote{FBA}}
          (default), \code{\dQuote{linearMOMA}} or
          \code{\dQuote{linearMOMA_COBRA}}; works only with GLPK
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.1.6 2009-12-03}{
  \itemize{
    \item added method \code{length} for objects of class \code{optsol_fluxdel}

    \item added method \code{\dQuote{[}} for objects of class
          \code{optsol_fluxdel}

    \item added argument \code{alg} in \code{optimizer()}: can be
          \code{\dQuote{FBA}} (default) or \code{\dQuote{linearMOMA}};
          works only with glpk

    \item added slot \code{algorithm} and methods \code{algorithm} and
          \code{algorithm<-} for objects of class \code{optsol_fluxdel}
          containing the name of the used algorithm.

    \item added slot \code{TOLERANCE} in \code{SYBIL_SETTINGS}

    \item added slot \code{MAXIMUM} in \code{SYBIL_SETTINGS}

    \item added slot \code{ALGORITHM} in \code{SYBIL_SETTINGS}

    \item added slot \code{OPT_DIRECTION} in \code{SYBIL_SETTINGS}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.1.5 2009-11-16}{
  \itemize{
    \item fixed a bug in \code{optObj_Class}, method \code{changeColsBnds} when
          using ILOG CPLEX as solver

    \item in \code{optObj_Class} the methods \code{getColsLowBnds} and
          \code{getColsUppBnds} now use \code{getLowBndsIdsCPLEX} and
          \code{getUppBndsIdsCPLEX} respectively when using ILOG CPLEX as solver
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.1.4 2009-10-01}{
  \itemize{
    \item fixed a bug in \code{nonZeroElements()}:
          empty rows and columns are now handled correctly when argument
          \code{maorder} is set to \code{\dQuote{column}} or \code{\dQuote{row}}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.1.3 2009-07-23}{
  \itemize{
    \item added support for low level interface \pkg{sybilCPLEX} (version 0.0.2)

    \item minor changes applied to \file{uglyHack.R} in order to support
          libsbml version 3.4.1
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.1.2 2009-07-21}{
  \itemize{
    \item added setting \code{LP_ALT_METHOD}, used for resolve in
          \code{optimizer()} and \code{refineSol()}
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.1.1 2009-07-14}{
  \itemize{
    \item added class \code{SYBIL_SETTINGS} which contains default settings,
          currently for the default lp solver and corresponding method.
          The class contains the relevant set/get methods to fit the
          content to ones needs.

    \item added method \code{addRowsCols} to class \code{optObj}

    \item added support for low level interface \CRANpkg{lpSolveAPI}
          (version 5.5.0.14)

    \item added support for low level interface \pkg{sybilCLP} (version 0.0.1)

    \item argument \code{resolve} in \code{oneFluxDel()}, \code{oneGeneDel()},
          \code{doubleFluxDel()} and \code{doubleGeneDel()}
      \itemize{
        \item default: \code{NA}
        \item if \code{resolve} is enabled, value should be a valid method
              depending on the desired solver (e.g. \code{\dQuote{exact}} in
              case of \code{solver = "glpk"})
      }
    \item renamed optObj-method \code{setColsBnds} to \code{changeColsBnds}

    \item renamed optObj-method \code{setRowsBnds} to \code{changeRowsBnds}

    \item renamed optObj-method \code{setObjCoefs} to \code{changeObjCoefs}

    \item argument \code{resolve} in \code{optimizer()} and \code{refineSol()}:
      \itemize{
        \item no longer boolean
        \item default: \code{NA}
        \item if non optimal solutions should be resolved: set to method
              resolve should use
      }

    \item argument \code{logfile} in \code{optimizer()} and \code{refineSol()}:
      \itemize{
        \item no longer boolean
        \item default: \code{NA}
        \item if a logfile should printed, \code{logfile} will be the filename
      }

    \item argument \code{scaling} in \code{optimizer()} and \code{refineSol()}:
      \itemize{
        \item no longer boolean
        \item default: \code{NA}
        \item if the model should be scaled, scaling will be the scaling method
      }

    \item added \code{solver} and \code{method} in \file{logfile}

    \item added argument \code{checkOptSolObj} to function \code{optimizer()}:
          print a warning, in cases where solution status \eqn{\neq}{!=} 0
          in objects of class optsol (default: \code{FALSE})

    \item added slots \code{chlb} and \code{chub} to class \code{optsol}:
      \itemize{
        \item containing lower and upper bounds of changed flux rates.
        \item replace method: \code{ch?b<-}
        \item get method: \code{ch?b}
      }
  }
}


% ---------------------------------------------------------------------------- %
\section{Changes in version 0.1.0 2009-07-09    (initial release)}{
  \itemize{
    \item support for low level interface \pkg{sybilGLPK} (version 0.1.0)
  }
}
