% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swimplot.R
\name{swimmer_points_from_lines}
\alias{swimmer_points_from_lines}
\title{Adding points to a swimmers plot which match up with lines}
\usage{
swimmer_points_from_lines(
  df_lines,
  id = "id",
  start = "start",
  end = "end",
  cont = NULL,
  name_shape = "type",
  name_col = NULL,
  name_size = NULL,
  name_fill = NULL,
  name_stroke = NULL,
  name_alpha = NULL,
  ...
)
}
\arguments{
\item{df_lines}{a data frame}

\item{id}{column name for id, default is 'id'}

\item{start}{column name where the line starts, default is 'start'}

\item{end}{column name where the line ends, default is 'end'}

\item{cont}{a column name of which lines continue (NA is does not continue) these will not have a point at the end of the line}

\item{name_shape}{a column name to map the point shape}

\item{name_col}{a column name to map the point colour}

\item{name_size}{a column name to map the point size}

\item{name_fill}{a column name to map the point fill}

\item{name_stroke}{a column name to map the point stroke}

\item{name_alpha}{a column name to map the point transparency}

\item{...}{additional geom_point() arguments}
}
\value{
a swimmer plot with points matching the lines
}
\description{
This function will create points at the beginning and end of line to match with  \code{\link{swimmer_lines}}.
}
\examples{


#Start with a base swimmer plot


swim_plot <-swimmer_plot(df=ClinicalTrial.Arm,id='id',end='End_trt',name_fill='Arm',col="black"
,id_order= 'Arm')


# Then add lines to the plot

swim_plot_with_lines <- swim_plot +
swimmer_lines(df_lines=ClinicalTrial.Response,id='id',start =
'Response_start',end='Response_end',name_col='Response',size=3)

# Add points to the start and end of the lines

swim_plot_with_lines_and_points <- swim_plot_with_lines+
swimmer_points_from_lines(df_lines=ClinicalTrial.Response,id='id',start =
'Response_start',end = 'Response_end', cont =
'Continued_response',name_col='Response',size=4)

# Add ggplot layers to improve the plot's aesthetic

swim_plot_with_lines_and_points +
ggplot2::scale_color_manual(name="Response",values=c("grey20","grey80"))+
ggplot2::scale_fill_manual(name="Treatment",values=c("#e41a1c", "#377eb8","#4daf4a"))+
ggplot2::ylab('Time (Days)')+
ggplot2::guides(fill = ggplot2::guide_legend(override.aes = list(shape =
NA)))+
ggplot2::scale_shape_manual(name='',values=c(17,15),breaks =
c('Response_start','Response_end'),labels=c('Response Start','Response End'))
}
\seealso{
\code{\link{swimmer_plot}} \code{\link{swimmer_points}} \code{\link{swimmer_lines}}  \code{\link{swimmer_lines}}  \code{\link{swimmer_arrows}}
}
