% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/das_intersects_strata.R
\name{das_intersects_strata}
\alias{das_intersects_strata}
\alias{das_intersects_strata.list}
\alias{das_intersects_strata.data.frame}
\title{DAS strata - points}
\usage{
das_intersects_strata(x, ...)

\method{das_intersects_strata}{list}(x, y, ...)

\method{das_intersects_strata}{data.frame}(x, y, x.lon = "Lon", x.lat = "Lat", ...)
}
\arguments{
\item{x}{a data frame (such as an object of class \code{das_df}) or a list.
If \code{x} is a list, then it must be the output of
\code{\link{das_effort}} or \code{\link{das_effort_sight}}.
If \code{x} is a data frame, the user must also specify
the coordinate columns of \code{x} using \code{x.lon} and \code{x.lat}}

\item{...}{ignored}

\item{y}{list of file path(s) of the CSV(s) that contain points defining each stratum.
The list may be named; see 'Value' section for how these names are used}

\item{x.lon}{character; name of the longitude column of \code{x}.
Ignored if \code{x} is a list; default is "Lon"}

\item{x.lat}{character; name of the latitude column of \code{x}.
Ignored if \code{x} is a list; default is "Lat"}
}
\value{
Logical columns are added to \code{x} indicating if each point intersected
  with the corresponding stratum polygon.
  The names of these columns are the names of \code{y};
  the element(s) of \code{y} will have the name InPoly#,
  where '#' is the index of that stratum polygon in \code{y}.

  If \code{x} is a list (meaning the output of one of the effort functions),
  then the stratum columns are added to both the segdata and sightinfo data frames.
  However, note that the columns added to the sightinfo data frame still indicate
  whether or not the segment midpoint was in the corresponding stratum,
  rather than the sighting point itself.
}
\description{
Determine if swfscDAS outputs intersect with strata polygons
}
\details{
Assigns DAS event points or segment midpoints to strata polygons
  using \code{\link[sf:geos_binary_pred]{st_intersects}}.

  If \code{x} is a list, then 1) it must be the output of
  \code{\link{das_effort}} or \code{\link{das_effort_sight}} and
  2) the segment midpoints (column names mlon and mlat, respectively)
  are the points checked if they intersect with each provided stratum.
  If \code{x} is a data frame, then the user must provide the columns
  that specify the point coordinates to check.

  \code{x} should not be an object of class \code{das_dfr},
  or an object of class \code{das_df} created with \code{add.dtll.sight = FALSE},
  because the ? and numeric event codes will have NA latitude and longitude values.
}
\examples{
y <- system.file("das_sample.das", package = "swfscDAS")
y.proc <- das_process(y)
y.eff <- das_effort(y.proc, method = "section", num.cores = 1)

stratum.file <- system.file("das_sample_stratum.csv", package = "swfscDAS")
das_intersects_strata(y.eff, list(InPoly = stratum.file), x.lon = "Lon", x.lat = "Lat")

das_intersects_strata(y.proc, list(stratum.file))

# Visualize effort midpoints and stratum polygon
require(sf)
y.eff.strata <- das_intersects_strata(y.eff, list(InPoly = stratum.file))
segdata <- st_as_sf(y.eff.strata$segdata, coords = c("mlon", "mlat"), crs = 4326)

# Make stratum polygon
stratum.df <- read.csv(stratum.file)
stratum.sfc <- st_sfc(
  st_polygon(list(matrix(c(stratum.df$Lon, stratum.df$Lat), ncol = 2))),
  crs = 4326
)

plot(segdata["InPoly"], axes = TRUE, reset = FALSE,
     xlim = c(-137, -142.5), ylim = c(42, 47))
plot(stratum.sfc, add = TRUE)

}
