% Generated by roxygen2 (4.0.2): do not edit by hand
\name{fast_E_M}
\alias{fast_EM}
\alias{fast_E_M}
\title{EM clustering}
\usage{
fast_E_M(dat, k, tol = 1e-08)

fast_EM(dat, k, tol = 1e-08)
}
\arguments{
\item{dat}{Input data: can be a table or a data frame (but the data frame must have only two columns).}

\item{k}{Numeric specification of the number of latent classes to compute.}

\item{tol}{Numeric specification of the convergence criterion.}
}
\value{
A list with components:
\item{\code{prob0} }{The probabilities of the latent classes.}
\item{\code{prob1} }{The probabilities for the first set of levels (\emph{viz.} the row levels of a frequency table). The rows of \code{prob1} sum to 1.}
\item{\code{prob2} }{The probabilities for the second set of levels (\emph{viz.} the column levels of a frequency table). The rows of \code{prob2} sum to 1.}
}
\description{
A fast procedure for Expectation-Maximization clustering.
}
\details{
This function assumes that the rows of a frequency table come from a multinomial distribution. The prior probabilities of
  the latent classes are initialized with a Dirichlet distribution (by means of \code{rdirichlet} from the package \pkg{gtools}).
}
\examples{
SndT_Fra <- read.csv2(system.file("extdata", "SndT_Fra.csv", package = "svs"))
E_M.SndT_Fra <- fast_E_M(SndT_Fra, k = 7)
E_M.SndT_Fra
}
\references{
Dempster, A. P., N. M. Laird and D. B. Rubin (1977) Maximum likelihood from incomplete data via the EM algorithm.
  \emph{Journal of the royal statistical society, series B} \strong{39} (1), 1--38.
}

