% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadratic_forms.R
\name{make_ppswor_approx_matrix}
\alias{make_ppswor_approx_matrix}
\title{Create a quadratic form's matrix to represent a variance estimator
for PPSWOR designs, based on commonly-used approximations}
\usage{
make_ppswor_approx_matrix(probs, method = "Deville-1")
}
\arguments{
\item{probs}{A vector of first-order inclusion probabilities}

\item{method}{A string specifying the approximation method to use.
See the "Details" section below.
Options include:
\itemize{
  \item "Deville-1"
  \item "Deville-2"
  \item "Beaumont-Emond"
}}
}
\value{
A symmetric matrix whose dimension matches the length of \code{probs}.
}
\description{
Several variance estimators for designs that use
unequal probability sampling without replacement (i.e., PPSWOR),
variance estimation tends to be more accurate
when using an approximation estimator that uses the first-order
inclusion probabilities (i.e., the basic sampling weights)
and ignores the joint inclusion probabilities.
This function returns the matrix of the quadratic form used
to represent such variance estimators.
}
\section{Deville's Estimators}{
 
The "Deville-1" and "Deville-2" approximations have been shown to be effective
for designs that use a fixed sample size with a high-entropy sampling method.
This includes most PPSWOR sampling methods,
but unequal-probability systematic sampling is an important exception.

Deville's variance estimators generally take the following form:
\deqn{
\hat{v}(\hat{Y}) = \sum_{i=1}^{n} c_i (\breve{y}_i - \frac{1}{\sum_{i=k}^{n}c_k}\sum_{k=1}^{n}c_k \breve{y}_k)^2
}
where \eqn{\breve{y}_i = y_i/\pi_i} is the weighted value of the the variable of interest,
and \eqn{c_i} are constants that depend on the approximation method used.  \cr \cr
The matrix of the quadratic form, denoted \eqn{\Sigma}, has
its \eqn{ij}-th entry defined as follows:
\deqn{
  \sigma_{ii} = c_i (1 - \frac{c_i}{\sum_{k=1}^{n}c_k}) \textit{ when } i = j \\
  \sigma_{ij}=\frac{-c_i c_j}{\sum_{k=1}^{n}c_k} \textit{ when } i \neq j \\
}
When \eqn{\pi_{i} = 1} for every unit, then \eqn{\sigma_{ij}=0} for all \eqn{i,j}.
If there is only one sampling unit, then \eqn{\sigma_{11}=0}; that is, the unit is treated as if it was sampled with certainty.

The constants \eqn{c_i} are defined for each approximation method as follows,
with the names taken directly from Matei and Tillé (2005).
\itemize{
  \item \strong{"Deville-1"}:
    \deqn{c_i=\left(1-\pi_i\right) \frac{n}{n-1}}
  \item \strong{"Deville-2"}:
    \deqn{c_i = (1-\pi_i) \left[1 - \sum_{k=1}^{n} \left(\frac{1-\pi_k}{\sum_{k=1}^{n}(1-\pi_k)}\right)^2 \right]^{-1}}
}
Both of the approximations \strong{"Deville-1"} and \strong{"Deville-2"} were shown
in the simulation studies of Matei and Tillé (2005) to perform much better
in terms of MSE compared to the strictly-unbiased
Horvitz-Thompson and Yates-Grundy variance estimators.
In the case of simple random sampling without replacement (SRSWOR),
these estimators are identical to the usual Horvitz-Thompson variance estimator.
}

\section{Beaumont-Emond Estimator}{
 
Beaumont and Emond (2022) proposed a variance estimator for unequal probability
sampling without replacement. This estimator is simply the Horvitz-Thompson
variance estimator with the following approximation for the joint inclusion
probabilities.
\deqn{
  \pi_{kl} \approx \pi_k \pi_l \frac{n - 1}{(n-1) + \sqrt{(1-\pi_k)(1-\pi_l)}}
}
In the case of cluster sampling, this approximation should be 
applied to the clusters rather than the units within clusters.
}

\references{
Matei, Alina, and Yves Tillé. 2005.
"Evaluation of Variance Approximations and Estimators
in Maximum Entropy Sampling with Unequal Probability and Fixed Sample Size."
Journal of Official Statistics 21(4):543-70.
}
\keyword{internal}
