% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/successive-difference-replication.R
\name{assign_hadamard_rows}
\alias{assign_hadamard_rows}
\title{Create a row-assignment matrix for Successive Difference Replication-Method}
\usage{
assign_hadamard_rows(
  n,
  hadamard_order,
  number_of_cycles = ceiling(n/hadamard_order),
  use_first_row = TRUE,
  circular = TRUE
)
}
\arguments{
\item{n}{The sample size of the data.}

\item{hadamard_order}{The order of the Hadamard matrix (i.e., the number of rows/columns)}

\item{number_of_cycles}{The number of cycles to use in the row assignment.
Must be at least as large as \code{n/hadamard_order}. Only
applies when \code{n} exceeds the number of available rows
in the Hadamard matrix. The number of available rows
is \code{hadamard_order} when \code{use_first_row = TRUE},
and \code{hadamard_order - 1} when \code{use_first_row = FALSE}.}

\item{use_first_row}{Whether to use the first row of the Hadamard matrix.
The first row of a Hadamard matrix is often all 1's, and so using the first
row to create replicate factors leads to the creation of a replicate
whose weights exactly match the full-sample weights. Thus, using the first row
of the Hadamard matrix may be undesirable for practical purposes,
even if it is valid for the purpose of variance estimation.}

\item{circular}{\code{TRUE} or \code{FALSE}. Only applies
when the number of available rows in the Hadamard matrix 
is at least as large as \code{n}.
Whether to make a circular row assignment,
so that the resulting successive-difference replication variance estimator
is equivalent to the SD2 variance estimator rather than the SD1 variance
estimator (see Ash 2014). The number of available rows
is \code{hadamard_order} when \code{use_first_row = TRUE},
and \code{hadamard_order - 1} when \code{use_first_row = FALSE}.}
}
\value{
A matrix with \code{n} rows and two columns. Each row
gives the assignment of two rows of a Hadamard matrix to the row of data.
}
\description{
Creates a row assignment matrix:
for each row of a dataset of size \eqn{n}, assigns two rows
of a Hadamard matrix.
}
\details{
Implements row-assignment methods described in Ash (2014)
and in Fay and Train (1995). The row-assignment method
depends on the number of available rows of the Hadamard matrix used.
The number of available rows
is \code{hadamard_order} when \code{use_first_row = TRUE},
and \code{hadamard_order - 1} when \code{use_first_row = FALSE}.

When the number of available Hadamard rows is at least as large as \code{n},
then the row assignment is as follows. Let \eqn{i=1,\dots,n} be the index
for the data that will receive row assignments, 
and let \eqn{a_j} denote row \eqn{j} of a Hadamard matrix. 
For \eqn{i < n}, the assignments
are entries \eqn{a_i} and \eqn{a_{i+1}} when \code{use_first_row = TRUE},
and when \code{use_first_row = FALSE}, the assignments are entries
\eqn{a_{i+1}} and \eqn{a_{i+2}}. The assignment for \eqn{i=n} depends on 
whether \code{circular = TRUE}. If \eqn{circular=TRUE}, then the assignment
for \eqn{i=n} is entries \eqn{a_i} and \eqn{a_1} if \code{use_first_row = TRUE},
and entries \eqn{a_{i+1}} and \eqn{a_2} if \code{use_first_row = FALSE}.

When the number of available Hadamard rows is less than \code{n},
then the row assignment method is the method denoted as RA1 in Ash (2014).
This method uses the argument \code{number_of_cycles} and 
does \emph{not} use the argument \code{circular}.
}
\references{
Ash, S. (2014). "\emph{Using successive difference replication for estimating variances}."
\strong{Survey Methodology}, Statistics Canada, 40(1), 47–59.
}
\keyword{internal}
