% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_rep_weights.R
\name{summarize_rep_weights}
\alias{summarize_rep_weights}
\title{Summarize the replicate weights}
\usage{
summarize_rep_weights(rep_design, type = "both")
}
\arguments{
\item{rep_design}{A replicate design object, created with either the \code{survey} or \code{srvyr} packages.}

\item{type}{Default is \code{"both"}. Use \code{type = "overall"}, for an overall summary of the replicate weights.
Use \code{type = "specific"} for a summary of each column of replicate weights,
with each column of replicate weights summarized in a given row of the summary. \cr
\cr
Use \code{type = "both"} for a list containing both summaries,
with the list containing the names \code{"overall"} and \code{"both"}.}
}
\value{
If \code{type = "both"} (the default), the result is a list of data frames
with names \code{"overall"} and \code{"specific"}. If \code{type = "overall"}, the result is
a data frame providing an overall summary of the replicate weights. \cr
\cr
The contents of the \code{"overall"} summary are the following:
\itemize{
 \item{"nrows"}{: Number of rows for the weights}
 \item{"ncols"}{: Number of columns of replicate weights}
 \item{"degf_svy_pkg"}{: The degrees of freedom according to the survey package in R}
 \item{"rank"}{: The matrix rank as determined by a QR decomposition}
 \item{"avg_wgt_sum"}{: The average column sum}
 \item{"sd_wgt_sums"}{: The standard deviation of the column sums}
 \item{"min_rep_wgt"}{: The minimum value of any replicate weight}
 \item{"max_rep_wgt"}{: The maximum value of any replicate weight}
}

If \code{type = "specific"}, the result is a data frame providing a
summary of each column of replicate weights, with each column of replicate weights
described in a given row of the data frame.
The contents of the \code{"specific"} summary are the following:
\itemize{
 \item{"Rep_Column"}{: The name of a given column of replicate weights.
  If columns are unnamed, the column number is used instead}
 \item{"N"}{: The number of entries}
 \item{"N_NONZERO"}{: The number of nonzero entries}
 \item{"SUM"}{: The sum of the weights}
 \item{"MEAN"}{: The average of the weights}
 \item{"CV"}{: The coefficient of variation of the weights (standard deviation divided by mean)}
 \item{"MIN"}{: The minimum weight}
 \item{"MAX"}{: The maximum weight}
}
}
\description{
Summarize the replicate weights of a design
}
\examples{

# Load example data
suppressPackageStartupMessages(library(survey))
data(api)

dclus1 <- svydesign(id=~dnum, weights=~pw, data=apiclus1, fpc=~fpc)
dclus1$variables$response_status <- sample(x = c("Respondent", "Nonrespondent",
                                                 "Ineligible", "Unknown eligibility"),
                                           size = nrow(dclus1),
                                           replace = TRUE)
rep_design <- as.svrepdesign(dclus1)

# Adjust weights for cases with unknown eligibility
ue_adjusted_design <- redistribute_weights(
    design = rep_design,
    reduce_if = response_status \%in\% c("Unknown eligibility"),
    increase_if = !response_status \%in\% c("Unknown eligibility"),
    by = c("stype")
)

# Summarize replicate weights

summarize_rep_weights(rep_design, type = "both")

# Compare replicate weights

rep_wt_summaries <- lapply(list('original' = rep_design,
                                'adjusted' = ue_adjusted_design),
                           summarize_rep_weights,
                           type = "overall")
print(rep_wt_summaries)

}
