% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_functions.R
\name{cat4}
\alias{cat4}
\title{Convenience function for four-category color scheme}
\usage{
cat4(g, reverse = FALSE)
}
\arguments{
\item{g}{ggplot object containing a Kaplan-Meier plot}

\item{reverse}{should the order of the colors be reversed?}
}
\value{
Returns a ggplot object
}
\description{
Convenience function to change the color scheme to
four colors: Green, blue, red, and yellow; i.e.
like the ski slopes but with yellow instead of black.
}
\examples{
library(survival)
library(dplyr)
veteran \%>\%
    survfit(Surv(time, status) ~ celltype, data = .) \%>\%
   plot_survfit(cuminc = FALSE) \%>\%
   cat4(reverse = TRUE)
}
\author{
Daniel Lindholm
}
