% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_models.R
\name{rank_models}
\alias{rank_models}
\title{Rank a collection of survstan models}
\usage{
rank_models(formula, data, survreg, baseline, dist = NULL, ...)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{data an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which function is called.}

\item{survreg}{survival regression models to be fitted (AFT, AH, PH, PO and YP).}

\item{baseline}{baseline distributions to be fitted; options currently available are: exponential, weibull, lognormal, loglogistic and Birnbaum-Saunders (fatigue) distributions.}

\item{dist}{alternative way to specify the baseline distributions (for compability with the \code{\link[survival]{survreg}} function); default is NULL.}

\item{...}{further arguments passed to other methods.}
}
\value{
a tibble containing the fitted models ranked according to their AICs.
}
\description{
Rank a collection of survstan models
}
\examples{
\donttest{
library(survstan)
library(dplyr)

veteran <- veteran \%>\%
  mutate(across(c(trt, prior, celltype), as.factor))
fits <- rank_models(
  formula = Surv(time, status) ~ celltype+karno,
  data = veteran,
  survreg = c("aftreg", "ahreg", "phreg", "poreg", "ypreg"),
  baseline = c("exponential", "weibull", "lognormal", "loglogistic", "fatigue")
)
}


}
