% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{alpha_star}
\alias{alpha_star}
\title{Calculates parameter \eqn{\alpha^*} of \eqn{q^*(b)} to optimize the
evidence based lower bound (ELBO) in \code{survregVB.fit} and
\code{survregVB.frailty.fit}.}
\usage{
alpha_star(alpha_0, delta)
}
\arguments{
\item{alpha_0}{The shape hyperparameter \eqn{\alpha_0} of the prior
distribution of the scale parameter, \emph{b}.}

\item{delta}{A binary vector indicating right censoring.}
}
\value{
Parameter \eqn{\alpha^*} of \eqn{q^*(b)}.
}
\description{
Calculates parameter \eqn{\alpha^*} of \eqn{q^*(b)} to optimize the
evidence based lower bound (ELBO) in \code{survregVB.fit} and
\code{survregVB.frailty.fit}.
}
\seealso{
\code{\link{survregVB.fit}}

\code{\link{survregVB.frailty.fit}}
}
