% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cox.R
\name{cox_as_data_frame}
\alias{cox_as_data_frame}
\title{Turns a coxph result to a data frame}
\usage{
cox_as_data_frame(
  coxphsummary,
  unmangle_dict = NULL,
  factor_id_sep = ":",
  sort_by = NULL
)
}
\arguments{
\item{coxphsummary}{The summary.coxph or coxph result object}

\item{unmangle_dict}{An unmangle dict of mangled column name -> readable column name (as created by analyse_multivariate)}

\item{factor_id_sep}{The frame contains one column "factor.id" which is a composite of covariate name and,
if categorical, the factor level (one line for each factor level except for the reference level)}

\item{sort_by}{A vars() list of one or more symbolic column names.
This frame contains the variables "Lower_CI", "HR", "Upper_CI", "Inv_Lower_CI", "Inv_HR", "Inv_Upper_CI", "p".
You can choose to sort by any combination. Use desc() to sort a variable in descending order.}
}
\value{
A tibble.
}
\description{
Extracts useful information from a coxph/summary.coxph into a data frame which is ready
for printing or further analysis
}
