% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_opts.R, R/show_opts.R
\name{set_opts}
\alias{set_opts}
\alias{show_opts}
\title{Set certain options}
\usage{
set_opts(
  reset = NULL,
  mode = NULL,
  adj = NULL,
  output = NULL,
  file = NULL,
  .file_temp = NULL,
  count = NULL,
  lpe = NULL,
  drop_na = NULL,
  max_levels = NULL
)

show_opts()
}
\arguments{
\item{reset}{reset all options to their default values?}

\item{mode}{\code{"general"} or \code{"NCHS"}. See below for details.}

\item{adj}{adjustment to the Korn and Graubard confidence intervals for proportions. See
\code{svyciprop_adjusted()} for details.}

\item{output}{specify how the output is printed: \code{"auto"} (default); \code{"huxtable"}, \code{"gt"}, or
\code{"kableExtra"}; \code{"raw"}; \code{"Excel"} or \code{"CSV"}. If \code{output} is \code{"Excel"} or \code{"CSV"}, must also specify
\code{file}. If \code{output} is \code{"Excel"}, be sure to install \code{openxlsx2} and \code{mschart}.}

\item{file}{file name (see \code{output}).}

\item{.file_temp}{place \code{file} in a temporary folder?}

\item{count}{round counts to the nearest integer (\code{"int"}) or one thousand (\code{"1k"}).}

\item{lpe}{identify low-precision estimates?}

\item{drop_na}{drop missing values (\code{NA})? Categorical variables only.}

\item{max_levels}{a categorical variable can have at most this many levels.
Used to avoid printing huge tables.}
}
\value{
(Nothing.)
}
\description{
\code{set_opts()} sets certain package options. To view these options, use \code{show_opts()}.
For more advanced control and detailed customization, experienced  users can
also employ \code{\link[=options]{options()}} and \code{\link[=show_options]{show_options()}} (refer to \link{surveytable-options}
for further information).
}
\details{
If you are not setting a particular option, leave it as \code{NULL}.

\code{mode} can be either \code{"general"} or \code{"NCHS"} and has the following meaning:
\itemize{
\item \code{"general"}:
\itemize{
\item Round counts to the nearest integer -- same as \code{count = "int"}.
\item Do not look for low-precision estimates -- same as \code{lpe = FALSE}.
\item Percentage CI's: use standard Korn-Graubard CI's -- same as \code{adj = "none"}.
}
\item \code{"nchs"}:
\itemize{
\item Round counts to the nearest 1,000 -- same as \code{count = "1k"}.
\item Identify low-precision estimates -- same as \code{lpe = TRUE}.
\item Percentage CI's: adjust Korn-Graubard CI's for the number of degrees of
freedom, matching the SUDAAN calculation -- same as \code{adj = "nchs"}. This
is appropriate for some, but not all, NCHS data systems. For some NCHS
data systems, such as NHIS, you might need to set \code{adj} to one of the other values.
}
}

\code{adj} specifies the adjustment to the Korn and Graubard confidence intervals for
proportions. See \code{svyciprop_adjusted()} for details.

\code{output} determines how the output is printed:
\itemize{
\item \code{"auto"} (default): automatically select the table-making package, depending on the
destination (such as screen, HTML, or PDF / LaTeX).
\item \code{"huxtable"}, \code{"gt"}, or \code{"kableExtra"}: use this table-making package. Be sure
that this package is installed.
\item \code{"raw"}: unformatted / raw output. This is useful for getting lots of significant digits.
\item \code{"Excel"}: print to an Excel workbook. Please specify the name of an Excel file using
the \code{file} argument. Before using Excel printing, please be sure to install these
packages: \code{openxlsx2} and \code{mschart}.
\item \code{"CSV"}: print to a comma-separated values (CSV) file. Please specify the name of a
CSV file using the \code{file} argument.
}
}
\examples{
set_survey(namcs2019sv)

# Round counts to the nearest one thousand:
set_opts(count = "1k")
tab("AGER")
set_opts(count = "int")

show_opts()
}
\seealso{
Other options: 
\code{\link{set_survey}()},
\code{\link{show_options}()},
\code{\link{surveytable-options}}
}
\concept{options}
