% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection.R
\name{make_projection}
\alias{make_projection}
\title{Outputs the survey projection onto the agent or symbolic layer}
\usage{
make_projection(
  data,
  layer,
  threshold_method = NULL,
  method_value = NULL,
  centre = NULL,
  similarity_metric = NULL
)
}
\arguments{
\item{data}{A data frame corresponding to a survey}

\item{layer}{A string flag specifying which layer to project
\itemize{
\item \code{"agent"} produces the network corresponding to the agents, which we assume
to be rows in \code{data}
\item \code{"symbolic"} produces the network corresponding to the symbols, or items,
which we assume to be columns in \code{data}
}}

\item{threshold_method}{A string flag specifying how edges are selected in
the network representation.
\itemize{
\item \code{"raw_similarity"} means we remove all edges whose weight, meaning node
similarity, is below a specified threshold.
\item \code{"target_lcc"} finds the value of the threshold that results in the network
whose largest connected component is as close as possible to a specified
value. In general a range of thresholds will satisfy this condition, and we
choose the upper limit of this range.
\item \code{"target_ad"} finds the value of the threshold that results in the network
whose average degree is as close as possible to a specified value.
}}

\item{method_value}{A utility variable that we interpret according to the
\code{threshold_method} chosen.
\itemize{
\item If \code{threshold_method = "raw_similarity"}, then \code{method_value} is
interpreted as the similarity threshold, and thus is in the range \verb{[-1, 1]}.
A value of -1 means no edges are removed, and a value of 1 means all edges
are removed.
\item If \code{threshold_method = "target_lcc"}, then \code{method_value} is interpreted as
the desired fractional size of the largest connected component, in the range
\verb{[0, 1]}. E.g., when set to 0, no nodes are connected, and if set to 1, the
network is as sparse as possible while remaining fully connected.
\item If \code{threshold_method = "target_ad"}, then \code{method_value} is interpreted as
the desired average degree. We assume that \code{method_value} is normalised to
the range \verb{[0, 1]} When \code{method_value = 0}, then no nodes are connected, and
if \code{method_value = 1}, the network is complete, meaning it contains every
possible edge.
}}

\item{centre}{If \code{FALSE}, we shift edge weights by 1 from \verb{[-1, 1]} to \verb{[0, 2]}.
Defaults to TRUE.}

\item{similarity_metric}{This currently has just one allowed value, namely the
Manhattan distance, which is the default.}
}
\value{
A data frame corresponding to the edge list of the specified network. It
contains three columns named
\itemize{
\item \code{u}, the first node adjacent to the edge
\item \code{v}, the second node adjacent to the edge, and
\item \code{weight}, the similarity between nodes \code{u} and \code{v}
}
}
\description{
\code{make_projection()} outputs the agent or symbolic network corresponding
to a survey, i.e. the row or column projection.
}
\examples{
S <- make_synthetic_data(20, 5)
}
