% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likert.R
\name{matrix_likert}
\alias{matrix_likert}
\title{Plot Likert-scale responses using ggplot2.}
\usage{
matrix_likert(
  dataset,
  question,
  labels = NULL,
  colors = NULL,
  weights = NULL,
  na.rm = TRUE
)
}
\arguments{
\item{dataset}{The input dataframe (or tibble) of survey questions}

\item{question}{The columns that contain each of the response options for a
question, can be selected by using \strong{tidyselect} semanatics or providing a
vector of column names or numbers}

\item{labels}{Optional vector specifying labels for each response category. If not provided,
it extracts labels from the original dataset.}

\item{colors}{Optional vector specifying colors for each response category. Default colors are provided
for 3 and 5 categories. If not specified, the function expects a vector of color codes.}

\item{weights}{Optional variable containing survey weights. If provided,
frequencies and counts will be weighted accordingly.}

\item{na.rm}{Logical indicating whether to remove NA values from \code{question}
before analysis.}
}
\value{
A ggplot2 object representing a diverging stacked bar chart displaying the distribution of
Likert-scale responses. The chart is customized based on the provided or extracted labels and colors.
}
\description{
The function produces a visually appealing diverging stacked bar chart,
allowing for easy interpretation of the distribution of responses to a
specific Likert-scale question. The function supports customization of
labels, colors, and weights, providing flexibility in data representation.
}
\seealso{
Other matrix questions: 
\code{\link{matrix_freq}()},
\code{\link{matrix_mean}()},
\code{\link{matrix_table}()}
}
\concept{matrix questions}
