% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardise.R
\name{standardise_to}
\alias{standardise_to}
\alias{standardize_to}
\title{Constructor for a standardising population used for survextrap
outputs}
\usage{
standardise_to(newdata, nstd = 1, random = FALSE)

standardize_to(newdata, nstd = 1, random = FALSE)
}
\arguments{
\item{newdata}{Data frame describing a population.}

\item{nstd}{Number of draws from the population distribution used
per MCMC sample from the parameters when \code{random=TRUE}.
With the default of 1, the value of the covariate vector \eqn{X}
is essentially treated as if it were an additional parameter in
the Bayesian model, drawn by Monte Carlo independently of the
remaining parameters.}

\item{random}{By default this is \code{FALSE}, indicating that
standardised samples should be obtained by concatenating the
posterior samples for each covariate value in the standard
population.  The sample from the standardised posterior of
parameters then has size \code{niter} times the number of rows in
\code{newdata}, where \code{niter} is the number of MCMC
iterations used in the original \code{survextrap} fit.  Computing
the resulting output function (e.g. RMST which uses numerical
integration) can then be computationally intensive if this sample
size is large.

A quicker alternative is to sample a random row of the standard
population for each MCMC iteration.  The standardised sample from
the posterior then has size \code{niter}.  This is specified by
using \code{random=TRUE}.  If this is used, then the result
depends on the random number seed, and it should be checked that
the results are stable to within the required number of
significant figures.  If not, run \code{survextrap} with more
MCMC iterations or increase \code{nstd} here.}
}
\value{
A copy of \code{newdata}, but with attributes added to
indicate that this should be used as a standard population.  When
this \code{newdata} is passed to \code{survextrap}'s output
functions, the outputs will then be presented as an average over
the empirical distribution of covariate values described by
\code{newdata}, rather than as one output per row of
\code{newdata} (distinct covariate values).
}
\description{
Standardised outputs are outputs from models with covariates, that
are defined by marginalising (averaging) over covariate values in a
given population, rather than being conditional on a given
covariate value.
}
\details{
These are produced by generating a Monte Carlo sample from
the joint distribution of parameters \eqn{\theta} and covariate
values \eqn{X}, \eqn{p(X,\theta) = p(\theta|X)p(X)}, where
\eqn{p(X)} is defined by the empirical distribution of covariates
in the standard population.

Hence applying a vectorised output function \eqn{g()} (such as the
RMST or survival probability) to this sample produces a sample from
the posterior of \eqn{\int g(\theta|X) dX}: the average RMST (say)
for a heterogeneous population.

See the Examples vignette for some examples and notes on
computation.
}
\examples{
rxph_mod <- survextrap(Surv(years, status) ~ rx, data=colons, fit_method="opt")
ref_pop <- data.frame(rx = c("Obs","Lev+5FU"))

# covariate-specific outputs
survival(rxph_mod, t = c(5,10), newdata = ref_pop)

# standardised outputs
survival(rxph_mod, t = c(5,10), newdata = standardise_to(ref_pop))

}
