% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num_check.R
\name{num_check}
\alias{num_check}
\title{Check Columns for Non-Numbers}
\usage{
num_check(data = NULL, col = NULL)
}
\arguments{
\item{data}{(dataframe) object containing at least one column of supposed dates}

\item{col}{(character or numeric) name(s) or column number(s) of the column(s) containing putative dates in the data object}
}
\value{
(list) malformed numbers from each supplied column in separate list elements
}
\description{
Identifies any elements in the column(s) that would be changed to NA if \code{as.numeric} is used on the column(s). This is useful for quickly identifying only the "problem" entries of ostensibly numeric column(s) that is/are read in as a character.
}
\examples{
# Create dataframe with a numeric column where some entries would be coerced into NA
spp <- c('salmon', 'bass', 'halibut', 'eel')
ct <- c(1, '14x', '_23', 12)
ct2 <- c('a', '2', '4', '0')
ct3 <- c(NA, 'Y', 'typo', '2')
fish <- data.frame('species' = spp, 'count' = ct, 'num_col2' = ct2, 'third_count' = ct3)

# Use `num_check()` to return only the entries that would be lost
num_check(data = fish, col = c("count", "num_col2", "third_count"))
}
