% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github_ls.R
\name{github_ls}
\alias{github_ls}
\title{List Objects in a GitHub Repository}
\usage{
github_ls(repo = NULL, folder = NULL, recursive = TRUE, quiet = FALSE)
}
\arguments{
\item{repo}{(character) full URL for a GitHub repository (including "github.com")}

\item{folder}{(NULL/character) either \code{NULL} or the name of the folder to list. If \code{NULL}, the top-level contents of the repository will be listed}

\item{recursive}{(logical) whether to recursively list contents (i.e., list contents of sub-folders identified within previously identified sub-folders)}

\item{quiet}{(logical) whether to print an informative message as the contents of each folder is being listed}
}
\value{
(dataframe) three-column dataframe including (1) the names of the contents, (2) the type of each content item (e.g., file/directory/etc.), and (3) the full path from the starting folder to each item
}
\description{
Accepts a GitHub repository URL and identifies all files in the specified folder. If no folder is specified, lists top-level repository contents. Recursive listing of sub-folders is supported by an additional argument. This function only works on repositories (public or private) to which you have access.
}
\examples{
\dontrun{
# List complete contents of the `supportR` package repository
github_ls(repo = "https://github.com/njlyon0/supportR", recursive = TRUE, quiet = FALSE)
}

}
