\name{rotation.design}
\alias{rotation.design}
\title{
Creating a choice experiment design using the rotation or mix-and-match method
}
\description{
This function creates a choice experiment design according to the rotation or mix-and-match method.
}
\usage{
rotation.design(candidate.array = NULL, attribute.names, 
                nalternatives, nblocks, row.renames = TRUE, 
                randomize = FALSE, seed = NULL)
}
\arguments{
  \item{candidate.array}{
A data frame containing an array created by the user. Normally, when this function is used, this argument does not need to be set by the user.
}
  \item{attribute.names}{
A list of the names of attributes and levels.
}
  \item{nalternatives}{
An integer value describing the number of alternatives per choice set, excluding an opt-out alternative such as a "none of these."
}
  \item{nblocks}{
An integer value describing the number of blocks into which a choice experiment design is divided.
}
  \item{row.renames}{
A logical variable describing whether or not the row names of a choice experiment design created by this function are changed. When its value is \code{TRUE} (default), integer values are assigned to the row names starting from 1. When its value is \code{FALSE}, the row names are the same as those of an array created by the function \code{oa.design} (included in the package \pkg{DoE.base}) via the function \code{rotation.design}, or those of an array assigned to the argument \code{candidate.array} by the user.
}
  \item{randomize}{
If this argument is \code{TRUE} (default), the function executes the mix-and-match method. If \code{FALSE}, the function executes the rotation method.
}
  \item{seed}{
Seed for a random number generator.
}
}
\details{
This function creates an unlabeled (generic) choice experiment design according to the rotation or mix-and-match method (Johnson et al. 2007) (see "Details" for the function \code{Lma.design} about the types of choice experiment design). Each method depends on an orthogonal main-effect array generated by the function \code{oa.design} in the package \pkg{DoE.base} or an arbitrary array set by the user.

The rotation method uses an orthogonal main-effect array as the first alternative in each choice set; this method creates one or more additional alternative(s) by adding a constant to each attribute level of the first alternative; the \emph{k}th(>= 2) alternative in the \emph{j}th (= 1, 2, ..., J) choice set is created by adding one to each of the \emph{m} attributes in the \emph{k} - 1 th alternative in the \emph{j}th choice set. If the level of the attribute in the \emph{k} - 1 th alternative is maximum, then the level of the attribute in the \emph{k} th alternative is assigned the minimum value. 

The mix-and-match method modifies the rotation method by introducing the randomizing process. After placing a set of \emph{N} alternatives created from the orthogonal main-effect array into an urn, one or more additional set(s) of \emph{N} alternatives are created using the rotation method and placed into different urn(s). A choice set is generated by selecting one alternative from each urn at random. This selection process is repeated, without replacement, until all the alternatives are assigned to \emph{N} choice sets. These \emph{N} choice sets correspond to a choice experiment design.

When the mix-and-match method is implemented by this function, the argument \code{randomize} is set as \code{TRUE} (default). When the rotation method is implemented by this function, the argument is set as \code{FALSE}.

When this function is used, the combination of attributes and attribute levels, the number of alternatives per choice set excluding an opt-out alternative, and the number of blocks are respectively assigned to the arguments.

The combination of attributes and attribute levels are assigned to the argument \code{attribute.names} in list format. For example, the alternative has three attributes, each of which has three levels: an attribute X with the three levels of x1, x2, and x3; an attribute Y with the three levels of y1, y2, and y3; and an attribute Z with the three levels of 10, 20, and 30. In this case, the argument \code{attribute.names} is set to be \code{list(X = c("x1", "x2", "x3"), Y = c("y1", "y2", "y3"), Z = c("10", "20", "30"))}.

The number of alternatives per choice set is defined by the argument \code{nalternatives}: the number of alternatives does not include an opt-out alternative such as the option "none of these."

Similar to the function \code{Lma.design}, this function can divide a choice experiment design into two or more blocks based on the argument \code{nblocks}. A choice experiment design is randomly divided into \code{nblocks} blocks; therefore, \code{nblocks} must be divisors of the number of choice sets included in the choice experiment design.

Under default settings, this function uses an orthogonal main-effect array that is automatically produced by the function \code{oa.design} based on the argument \code{attribute.names} to create a choice experiment design. However, when there is no array corresponding to the argument \code{attribute.names}, the function \code{oa.design} returns a full factorial based on the argument \code{attribute.names} (See help for the function \code{oa.design} in the packge \pkg{DoE.base}). On the other hand, when this function does not create a choice experiment design matching the user's requirements, the user might achieve it by assigning an arbitrary (user-defined) array to the argument \code{candidate.array}: this function uses the array to create a choice experiment design. When the user-defined array is used, the last column of the array must contain a column for dividing the design based on the argument \code{nblocks}. The arguments \code{attribute.names} and \code{nblocks} must also be assigned according to the array.
}
\value{
This function returns an object of S3 class "cedes" (see Lma.design) that is a list with the following components.
  \item{alternatives }{A list of objects, \code{alt.j}: the \emph{j}th alternative in each choice set created by this function. Each of \code{alt.j} includes a variable \code{BLOCK} describing the serial number of blocks, a variable \code{QES} describing the serial number of choice experiment questions for each value of the variable \code{BLOCK}, a variable \code{ALT} describing the serial number of alternatives for each value of the \code{QES} variable, and attribute variables corresponding to the argument \code{attribute.names}.}
  \item{candidate }{A candidate array used for creating a choice experiment design, which is generated using the \code{oa.design} function in the \pkg{DoE.base} package or which the user sets for the argument \code{candidate.array}. When \code{nblocks} >= 2, the last column in this value (\code{candidate}) shows a factor that is used for blocking.}
  \item{design.information }{Information related to the CE design created by this function, which is used as arguments in post-processing functions, such as the functions \code{questionnaire} and \code{make.design.matrix}. This list includes objects such as the number of blocks into which the CE design is divided (\code{nblocks}), the number of questions per block (\code{nquestions}), the number of alternatives per choice set excluding an opt-out alternative (\code{nalternatives}), and the number of attributes per alternative (\code{nalternatives}).}
An error message is displayed when the argument \code{nblocks} does not match a choice experiment design. In such a case, the argument \code{nblocks} is set to be a divisior of the number of rows of the choice experiment design. Ohter messages are frequently shown immediately after executing this function when it works properly. These messages are taken from the function \code{oa.design} and may be valuable to a user who wishes to define the original array and assign it the argument \code{candidate.array}.
}
\references{
Johnson, F. R., Kanninen, B., Bingham, M. and \"{O}zdemir, S. (2007) Experimental Design for Stated Choice Studies. In B. J. Kanninen (ed), \emph{Valuing Environmental Amenities Using Stated Choice Studies: A Common Sense Approach to Theory and Practice}. pp.159--202. Springer.

Aizaki, H. (2012) Basic Functions for Supporting an Implementation of Choice Experiments in R. \emph{Journal of Statistical Software, Code Snippets}, \bold{50}(2), 1--24. \url{http://www.jstatsoft.org/v50/c02/}
}
\author{
Hideo Aizaki
}
\seealso{
\code{\link{Lma.design}}, \code{\link{syn.res1}}, \code{\link[DoE.base]{oa.design}}
}
\examples{
# See "Details" for the data set syn.res1.
des1 <- rotation.design(attribute.names = list(
 Region = c("Reg_A", "Reg_B", "Reg_C"), 
 Eco = c("Conv.", "More", "Most"), 
 Price = c("1", "1.1", "1.2")), 
 nalternatives = 2, nblocks = 1, row.renames = FALSE, 
 randomize = TRUE, seed = 987)
des1
}
\keyword{design}
