% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TfidfVectorizer.R
\docType{data}
\name{TfIdfVectorizer}
\alias{TfIdfVectorizer}
\title{TfIDF(Term Frequency Inverse Document Frequency) Vectorizer}
\format{\code{\link{R6Class}} object.}
\usage{
TfIdfVectorizer
}
\description{
It aims to provide a standardized way of creating TF-IDF features just like python's sklearn library.
              It also consists of fit, transform methods (similar to sklearn) to make it easier for you switch between R and Python.
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
tf_object = TfIdfVectorizer$new(max_df, min_df, max_features, smooth_idf)
tf_object$fit(sentences)
tf_matrix = tf_object$transform(sentences)
tf_matrix = tf_object$fit_transform(sentences) ## alternate
}
}

\section{Methods}{

\describe{
    \item{\code{$new()}}{Initialise the instance of the vectorizer}
    \item{\code{$fit()}}{creates a memory of count vectorizers but doesn't return anything}
    \item{\code{$transform()}}{based on encodings learned in \code{fit} method, return the tf-idf matrix }
    \item{\code{$fit_transform()}}{returns tf-idf matrix}
}
}

\examples{
df <- data.table::data.table(sents = c('i am alone in dark.',
                           'mother_mary a lot',
                           'alone in the dark?',
                           'many mothers in the lot....'))
tf <- TfIdfVectorizer$new(smooth_idf = TRUE, min_df = 0.3)
tf_features <- tf$fit_transform(df$sents)
}
\keyword{datasets}
