% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionsPlotting_base.R
\name{superbPlot.pointindividualline}
\alias{superbPlot.pointindividualline}
\title{superbPlot point and individual-line layout for within-subject design}
\usage{
superbPlot.pointindividualline(
  summarydata,
  xfactor,
  groupingfactor,
  addfactors,
  rawdata,
  pointParams = list(),
  lineParams = list(),
  errorbarParams = list(),
  facetParams = list()
)
}
\arguments{
\item{summarydata}{a data.frame with columns "center", "lowerwidth" and "upperwidth" for each level of the factors;}

\item{xfactor}{a string with the name of the column where the factor going on the horizontal axis is given;}

\item{groupingfactor}{a string with the name of the column for which the data will be grouped on the plot;}

\item{addfactors}{a string with up to two additional factors to make the rows and columns panels, in the form "fact1 ~ fact2";}

\item{rawdata}{always contains "DV" for each participants and each level of the factors}

\item{pointParams}{(optional) list of graphic directives that are sent to the geom_bar layer}

\item{lineParams}{(optional) list of graphic directives that are sent to the geom_bar layer}

\item{errorbarParams}{(optional) list of graphic directives that are sent to the geom_superberrorbar layer}

\item{facetParams}{(optional) list of graphic directives that are sent to the facet_grid layer}
}
\value{
a ggplot object
}
\description{
superbPlot comes with a few built-in templates for making the final plots.
All produces ggplot objects that can be further customized. Additionally, it is
possible to add custom-make templates (see vignette 6). The functions, to be
"superbPlot-compatible", must have these parameters:
}
\examples{
# This will make a plot with points and individual lines for each subject's scores
library(lsr)

# we take the Orange built-in data.frame which has a within-subject design
names(Orange) <- c("Tree","age","circ")
# turn the data into a wide format
Orange.wide <- longToWide(Orange, circ ~ age)
# the identifier to each tree must be in a column called id
Orange.wide$id = Orange.wide$Tree

# Makes the plots two different way:
superbPlot( Orange.wide, WSFactors = "age(7)",
  variables = c("circ_118","circ_484","circ_664","circ_1004","circ_1231","circ_1372","circ_1582"),
  adjustments = list(purpose = "difference", decorrelation = "none"),
  plotStyle= "pointindividualline"
)

# if you extract the data with superbData, you can 
# run this layout directly
processedData <- superbData(Orange.wide, WSFactors = "age(7)",
  variables = c("circ_118","circ_484","circ_664","circ_1004","circ_1231","circ_1372","circ_1582"),
  adjustments = list(purpose = "difference", decorrelation = "none"),
)

superbPlot.pointindividualline(processedData$summaryStatistic,
   "age",
   NULL,
   ".~.",
   processedData$rawData)

}
