% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WinerCompoundSymmetryTest.R
\name{WinerCompoundSymmetryTest}
\alias{WinerCompoundSymmetryTest}
\title{WinerCompoundSymmetryTest}
\usage{
WinerCompoundSymmetryTest(dta, cols)
}
\arguments{
\item{dta}{A data frame containing within-subject measures, one participant per line;}

\item{cols}{A vector indicating the columns containing the measures.}
}
\value{
p the p-value of the null hypothesis that the data are compound symmetric.
}
\description{
Run a test of compound symmetry.
  generates a data frame of random data suitable for analyses.
  It assesses the significance of the null hypothesis that
  the covariance matrix is compound symmetric. 
  This test is given without demonstration in 
  \insertCite{w91}{superb}, p. 517.
}
\examples{
# creates a small data frames with 4 subject's scores for 5 measures:
dta <- data.frame(cbind(
        col1 <- c(3., 6., 2., 2., 5.),
        col2 <- c(4., 5., 4., 4., 3.),
        col3 <- c(2., 7., 7., 8., 6.),
        col4 <- c(6., 8., 4., 6., 5.)
    ))
# performs the test (here p = 0.6733)
WinerCompoundSymmetryTest(dta)
# 0.6733123

}
\references{
\insertAllCited{}
}
