% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stby.R
\name{stby}
\alias{stby}
\title{Obtain Grouped Statistics With summarytools}
\usage{
stby(data, INDICES, FUN, ..., useNA = FALSE)
}
\arguments{
\item{data}{an R object, normally a data frame, possibly a matrix.}

\item{INDICES}{a grouping variable or a list of grouping variables,
each of length \code{nrow(data)}.}

\item{FUN}{a function to be applied to (usually data-frame) subsets of data.}

\item{\dots}{Further arguments to FUN.}

\item{useNA}{Make NA a valid grouping value in INDICES variable(s).
Set to \code{FALSE} explicitly to eliminate message.}
}
\value{
An object of classes \dQuote{list} and \dQuote{summarytools},
  giving results for each subset.
}
\description{
An adaptation base R's \code{\link{by}} function, designed to
optimize the results' display.
}
\details{
When the grouping variable(s) contain NA values, the
  \code{base::\link[base]{by}} function (as well as summarytools 
  versions prior to 1.1.0) ignores corresponding groups. Version 1.1.0
  allows setting \code{useNA = TRUE} to make new groups using
  NA values on the grouping variable(s), just as
  \code{dplyr::\link[dplyr]{group_by}} does.
  
  When NA values are detected and \code{useNA = FALSE}, a message is
  displayed; to disable this message, set \code{check.nas = FALSE}.
}
\examples{
data("tobacco")
with(tobacco, stby(data = BMI, INDICES = gender, FUN = descr,
                   check.nas = FALSE))
with(tobacco, stby(data = smoker, INDICES = gender, freq, useNA = TRUE))
with(tobacco, stby(data = list(x = smoker, y = diseased),
                   INDICES = gender, FUN = ctable, useNA = TRUE))
                   
}
\seealso{
\code{\link[base]{by}}, \code{\link[dplyr]{group_by}}
}
\keyword{utilities}
