print.summarytools <- function(x, method="pander", open=TRUE, ...) {

  # Build info.table and prepare the field  -----------------------------------

  if(method=="pander") {
    info.table <- c()
    for(a in c("df.name", "var.name", "var.label", "rows.subset")) {
      # other possible items are "date" and "col.names"
      if(a %in% names(attributes(x)))
        info.table <- append(info.table, paste(a, ":", paste(as.character(attr(x, a)),
                                                             collapse=", "),
                                               sep=""))
    }

    info.table <- sub("^df\\.name:",    "Dataframe name: ", info.table)
    info.table <- sub("^var\\.name:",   " Variable name: ", info.table)
   #info.table <- sub("^col\\.names:",  "  Column names: ", info.table)
    info.table <- sub("^var\\.label:",  "Variable label: ", info.table)
    info.table <- sub("^rows\\.subset:","   Rows subset: ", info.table)
   #info.table <- sub("^date:",         "          Date: ", info.table)
    info.table <- paste(info.table, collapse="\n")

   if(nchar(info.table)==0)
     info.table <- attr(x, "arg.str")
  }

  # for methods browser / viewer
  else {
    html.footer.line = paste("Generated by <a href='https://github.com/dcomtois/summarytools'>summarytools</a> package version ",
                             packageVersion(pkg = "summarytools"),
                             " (<a href='http://www.r-project.org/'>R</a> version ", getRversion(), ")",
                             "<br/>", Sys.Date(), sep="")
  }

  notes <- ifelse("notes" %in% names(attributes(x)),
                  yes = paste(attr(x,"notes")), no = "")

  # Printing descr objects ----------------------------------------------------
  if(attr(x, "st.type") == "descr") {

    # With method pander --------------------------------------
    if(method=="pander") {

      cat("\nDescriptive (Univariate) Statistics\n\n")
      cat(info.table)
      pander.args <- append(attr(x, "pander.args"), list(x=quote(x$stats)))
      do.call(pander::pander, pander.args)
      cat("Observations")
      pander.args <- append(attr(x, "pander.args"), list(x=quote(x$observ)))
      do.call(pander::pander, pander.args)
      cat(notes, "\n")
    }

    # With method viewer / browser --------------------------
    else if(grepl("(v|view)|(B|brow)",method)) {

      descr.table.html <-
        xtable::print.xtable(xtable::xtable(x = x$stats, align = paste("r", paste(rep("c",ncol(x$stats)),collapse=""),sep=""),
                                            digits = c(0,rep(attr(x, "pander.args")$round,ncol(x$stats)))),
                             type = "html", print.results = FALSE,
                             html.table.attributes = 'class="table table-striped table-bordered"')

      obs.table.html <-
        xtable::print.xtable(xtable::xtable(x = x$observ, align = paste("r", paste(rep("c",ncol(x$observ)),collapse=""),sep=""),
                                            digits = c(0,rep(attr(x, "pander.args")$round,ncol(x$observ)))),
                             type = "html", print.results = FALSE,
                             html.table.attributes = 'class="table table-striped table-bordered"')

      stpath <- find.package("summarytools")

      html.content <- tags$html(
        tags$header(
          includeCSS(path = paste(stpath,"includes/stylesheets/bootstrap.min.css", sep="/")),
          includeCSS(path = paste(stpath,"includes/stylesheets/custom.css", sep="/"))
        ),
        tags$body(
          div(class="container", # style="width:80%",
              h3("Descriptive Univariate Statistics"),
              h2(attr(x, "df.name")),
              if("rows.subset" %in% names(attributes(x)))
                p("Rows subset:",attr(x,"rows.subset")),
              #h4("Number of rows: ", attr(x, "n.obs")),
              br(),
              HTML(gsub("<td> ", "<td>", descr.table.html)),
              h3("Observations"),
              HTML(gsub("<td> ", "<td>", obs.table.html)),
              p(notes),
              HTML(text = html.footer.line)
          )
        )
      )

      htmlfile <- paste(tempfile(),".html",sep="")
      capture.output(html.content, file = htmlfile)
    }
  }

  # Printing dfSummary objects ------------------------------------------------
  else if(attr(x, "st.type") == "dfSummary") {

    # With method pander --------------------------
    if(method=="pander") {
      cat("\nDataframe summary\n")
      cat(info.table)
      pander.args <- append(attr(x, "pander.args"), list(x=quote(x)))
      do.call(pander::pander, pander.args)
    }

    # with method viewer or browser ---------------
    else if(grepl("(v|view)|(B|brow)",method)) {

      sanitize.colnames <- function(x) {
        x <- gsub("\\.", " ", x)
        x <- rapportools::capitalise(x)
        x <- sub("levels or stats", "Levels / Stats", x)
        return(x)
      }

      dfSummary.html <-
        xtable::print.xtable(xtable::xtable(x = x,digits = 0,
                                            align = paste("c", paste(rep("l",ncol(x)),collapse=""),sep="")),
                             include.rownames = FALSE, type = "html", print.results = FALSE,
                             sanitize.colnames.function = sanitize.colnames,
                             html.table.attributes = 'class="table table-striped table-bordered"')

      stpath <- find.package("summarytools")

      html.content <- tags$html(
        tags$header(
          includeCSS(path = paste(stpath,"includes/stylesheets/bootstrap.min.css", sep="/")),
          includeCSS(path = paste(stpath,"includes/stylesheets/custom.css", sep="/"))
        ),
        tags$body(
          div(class="container", #style="width:80%",
              h3("Dataframe Summary"),
              h2(attr(x, "df.name")),
              if("rows.subset" %in% names(attributes(x)))
                p("Rows subset:",attr(x,"rows.subset")),
              h4("Number of rows: ", attr(x, "n.obs")),
              br(),
              HTML(gsub("<td> ", "<td>", dfSummary.html)),
              p(notes),
              HTML(text = html.footer.line)
          )
        )
      )

      htmlfile <- paste(tempfile(),".html",sep="")
      capture.output(html.content, file = htmlfile)
    }
  }

  # printing freq objects -----------------------------------------------------
  else if(attr(x, "st.type") == "freq") {

    # with method pander -----------------------------
    if(method=="pander") {
      cat("\nFrequencies\n\n")
      cat(info.table)
      pander.args <- append(attr(x, "pander.args"), list(x=quote(x)))
      do.call(pander::pander, pander.args)
      cat(notes)
    }

    # with method viewer / browser --------------------
    else if(grepl("([v|V]iew)|(brow)",method)) {

      sanitize.colnames <- function(x) {
        x <- gsub("\\.", " ", x)
        x <- sub("\\%", "% ", x)
        return(x)
      }

      freq.table.html <-
        xtable::print.xtable(xtable::xtable(x = x, align = "rccccc",
                                            digits = c(0,0,rep(attr(x, "pander.args")$round,4))),
                             type = "html", print.results = FALSE,
                             sanitize.colnames.function = sanitize.colnames,
                             html.table.attributes = 'class="table table-striped table-bordered"')

      stpath <- find.package("summarytools")

      html.content <- tags$html(
        tags$header(
          includeCSS(path = paste(stpath,"includes/stylesheets/bootstrap.min.css", sep="/")),
          includeCSS(path = paste(stpath,"includes/stylesheets/custom.css", sep="/"))
        ),
        tags$body(
          div(class="container", #style="width:80%",
              h3("Frequencies"),
              h2(attr(x,"var.name")),
              if("rows.subset" %in% names(attributes(x)))
                p("Dataframe:",attr(x,"df.name")),
              if("rows.subset" %in% names(attributes(x)))
                p("Rows subset:",attr(x,"rows.subset")),
              br(),
              HTML(gsub("<td> ", "<td>", freq.table.html)), # To avoid initial space in cells
              p(notes),
              HTML(text = html.footer.line)
          )
        )
      )
      htmlfile <- paste(tempfile(),".html",sep="")
      capture.output(html.content, file = htmlfile)
    }
  }


  # Open the output html file --------------------------------------------
  if(grepl("v|View",method)) {
    if(!is.null(getOption("viewer")))
      rstudioapi::viewer(htmlfile)
    else
      utils::browseURL(htmlfile)
  } else if(grepl("b|Brow", method)) {
    if(open)
      utils::browseURL(htmlfile)
      #shell.exec(htmlfile)
  }

  # return file path for browser/viewer ----------------------------------
  if(grepl("(B|brow)|(V|view)", method)) {
    return(normalizePath(htmlfile))
  } else {
    return(invisible())
  }
}
