% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_named_vctr.R
\name{check_named_vctr}
\alias{check_named_vctr}
\title{Check a named vector}
\usage{
check_named_vctr(x, names, default)
}
\arguments{
\item{x}{A named vector.}

\item{names}{A character vector or list of character vectors of length one
specifying the names to be matched.}

\item{default}{Default value to return}
}
\value{
Either the original object, \code{x}, or the \code{default} value.
}
\description{
This function checks whether named lists and vectors contain
invalid values (like \code{NULL} or \code{NA}), have invalid names (such as missing
or empty names), ensures the number of valid names matches the number of
supplied values, and confirms that valid names from the object correspond
to the provided names. If any of these checks fail, the function returns
the \code{default} value.
}
\examples{

# returns NULL
check_named_vctr(x = c(one = 1, two = 2, 3), 
                 names = c("one", "two", "three"),
                 default = NULL)
                 
# returns x
check_named_vctr(x = list(one = 1, two = 2, three = 3), 
                 names = list("one", "two", "three"),
                 default = NULL)  

# also returns x
check_named_vctr(x = c(baako = 1, mmienu = 2, mmiensa = 3), 
                 names = list("baako", "mmienu", "mmiensa"),
                 default = NULL)              
                 
}
\author{
Ama Nyame-Mensah
}
