% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fires.R
\name{FIRES}
\alias{FIRES}
\title{The FIRES Algorithm for Subspace Clustering}
\usage{
FIRES(data, base_dbscan_epsilon = 1, base_dbscan_minpts = 4,
  minimumpercent = 25, k = 1, mu = 1, minclu = 1, split = 0.66,
  post_dbscan_epsilon = 1, post_dbscan_minpts = 1)
}
\arguments{
\item{data}{A matrix or data frame of input data.}

\item{base_dbscan_epsilon}{parameter for the dbscan execution that generates
the base clusters}

\item{base_dbscan_minpts}{parameter for the dbscan execution that generates
the base clusters}

\item{minimumpercent}{size a base-cluster must have relative to the average
size of base clusters so that it is not discarded}

\item{k}{amount of base-clusters that every base-cluster is compared to for
merging purposes}

\item{mu}{number of most similar clusters in which two clusters must overlap
in order to be considered best-merge-clusters of each other}

\item{minclu}{number of best-merge-candidates a cluster must have to be
considered a best-merge-cluster}

\item{split}{a base-cluster is split to merge it with two different clusters
iff both clusters resulting from the split have at least this size in
proportion to the average size of base-clusters}

\item{post_dbscan_epsilon}{parameter for the dbscan execution that turns the
cluster-approximations into the clusters that are output at the end}

\item{post_dbscan_minpts}{parameter for the dbscan execution that turns the
 cluster-approximations into the clusters that are output at the end}
}
\description{
The FIRES Algorithm follows a three phase framework: In a first phase,
base-clusters are generated using a clustering-algorithm on each dimension in
isolation. Then these base-clusters are merged in a second phase to find
multidimensional cluster-approximations. These approximations are then refined
in the third phase.
}
\details{
In this implementation, the first phase consists of a run of DBSCAN with the
parameters \emph{base_dbscan_epsilon} and \emph{base_dbscan_minpts} on the
objects as they appear from each particular dimension. Then, all of these
base-clusters whose size is smaller than \emph{minimumpercent} of the average
cluster size, e.g. 25% for the standard parameter setting, are discarded
because they are not likely to contain important information for the
clustering.

In the second phase, these base clusters are merged to produce subspace
cluster approximations. This is achieved by computing the
\emph{k}-most-similar clusters for each base-cluster. Then the set of
best-merge-candidates for each base-cluster is determined, which contains
those clusters whose \emph{k}-most-similar clusters overlap the \emph{k}-most
similar clusters of the cluster by at least \emph{mu}. If a cluster has at
least \emph{minclu} best-merge-candidates,it is considered a best-merge
cluster. Finally, every pair of best-merge-clusters that are
best-merge-candidates of each other is grouped together with all of their
best-merge-candidates to form the cluster approximations.

Note that some clusters need to be split and merged with two different other
clusters. This is done before the merging by determining whether the
intersection between a cluster and its most similar cluster as well as the
size of the cluster without this intersection are both larger than
\emph{split} times the average size of the base clusters.

In the third phase, base-clusters are repeatedly removed from
cluster-approximations if their removal improves the amount of objects that
are shared by all base-clusters in the approximation. Finally, to generate the
definitive clusters from the cluster approximation, for each approximation all
base-clusters in the approximation are combined and the a clustering algorithm
is performed on these points. In this implementation, DBSCAN was chosen for
this purpose and will be performed with the parameters
\emph{post_dbscan_epsilon} and \emph{post_dbscan_minpts}.
}
\examples{
data("subspace_dataset")
FIRES(subspace_dataset)
}
\references{
Hans-Peter Kriegel, Peer Kröger, Matthias Renz and Sebastian Wurst
 \emph{A Generic Framework for Efficient Subspace Clustering of
 High-Dimensional Data} In Proc. 5th IEEE International Conference on Data
 Mining, 2005
}
\seealso{
Other subspace.clustering.algorithms: \code{\link{CLIQUE}};
  \code{\link{P3C}}; \code{\link{ProClus}};
  \code{\link{SubClu}}
}

