% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prim.R
\name{prim.diversify}
\alias{prim.diversify}
\title{PRIM diversify strategy}
\usage{
prim.diversify(formula, data, X, y, n, peeling.quantile, min.support,
  max.peel = 0.1, train.fraction = 0.66, quality.function = base::mean,
  plot = FALSE)
}
\arguments{
\item{formula}{Formula with a response and terms}

\item{data}{Data frame to find rules in}

\item{X}{Optionally instead of using a formula: Data frame to find rules in}

\item{y}{Optionally instead of using a formula: Response vector, usually of type numeric}

\item{n}{Numer of attempts to run the PRIM algorithm}

\item{peeling.quantile}{Quantile to peel off for numerical variables}

\item{min.support}{Minimal size of a box to be valid}

\item{max.peel}{Maximal size of a peel, as a fraction. Defaults to 0.1}

\item{train.fraction}{Optional train-test split fraction used in validation, defaults to 0.66}

\item{quality.function}{Optional setting for function to use for determining subset quality, defaults to mean}

\item{plot}{Optional setting to plot intermediate results, defaults to false}
}
\value{
An S3 object of type prim.diversify
}
\description{
Provide a (hopefully) diverse number of box definitions
}
\details{
Because the final box depends on the data used, we re-run the PRIM peeling algorithm multiple times, each with a different random train/test split.
}
\examples{
  data(ames)
  p.div <- prim.diversify(
      SalePrice ~ . - PID - Order,
      data = ames,
      n = 5,
      peeling.quantile = 0.05,
      min.support = 0.05,
      plot = TRUE
  )
  summary(p.div)
  plot(p.div)
}
\author{
Jurian Baas
}
