% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roxygen-examples-parse.R
\name{roxygen_remove_extra_brace}
\alias{roxygen_remove_extra_brace}
\title{Fix \code{\link[tools:parse_Rd]{tools::parse_Rd()}} output}
\usage{
roxygen_remove_extra_brace(parsed)
}
\description{
Since \code{\link[tools:parse_Rd]{tools::parse_Rd()}} treats braces in quotes as literal braces when
determining brace symmetry, a brace might be added in error to the parsed
data (at the end). We'll remove one at the time, check if output is parsable
until no braces are left. If we end up with no braces left, we signal a
parsing error, otherwise, we return the initial (not parsable input due to
\emph{dont} sequence) with the trailing braces removed.
}
\examples{
styler:::parse_roxygen(
  c(
    "#' @examples",
    "#' x <- '{'",
    "#' \\\\dontrun{",
    "#' fu(x = 3)",
    "#' }"
  )
)
styler:::parse_roxygen(
  c(
    "#' @examples",
    "#' x <- '{'",
    "#' \\\\dontrun{",
    "#' c('{', \"'{{{\" ,\"[\")",
    "#' }"
  )
)
}
\keyword{internal}
