% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holdout.R
\name{holdout}
\alias{holdout}
\title{Data selection for holdout validation.}
\usage{
holdout(data, prop = 0.5, grouping = NULL, seed = NULL, determined = NULL)
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{prop}{A single value or vector of proportions of data in calibration sample. Defaults to .5, for an even split.}

\item{grouping}{Name of the grouping variable. Providing a grouping variable ensures that the provided proportion is selected within each group.}

\item{seed}{A random seed. See \code{\link{Random}} for more details.}

\item{determined}{Name of a variable indicating the pre-determined assignment to the calibration or the validation sample. This variable must be a factor containing only \code{NA} (no determined assingment), \code{"calibrate"}, or \code{"validate"}. If no variable is provided (the default) all cases are assigned randomly.}
}
\value{
Returns a list containing two \code{data.frame}s, called calibrate and validate. The first corresponds to the calibration sample, the second to the validation sample.
}
\description{
Split a \code{data.frame} into two subsets for holdout validation.
}
\examples{

# seeded selection, 25\% validation sample
data(fairplayer)
split <- holdout(fairplayer, .75, seed = 55635)
lapply(split, nrow) # check size of samples

}
\seealso{
\code{\link{crossvalidate}}
}
\author{
Martin Schultze
}
\concept{ACO subtests}
