% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpbdcpp.R
\name{lpbdcpp}
\alias{lpbdcpp}
\title{Estimate approximate ELBO}
\usage{
lpbdcpp(alpha_d, Sigma_Inv, kappa_t, kappa_s, mu_d, doc, V, mv)
}
\arguments{
\item{alpha_d}{the estimated alpha variables for the given document}

\item{Sigma_Inv}{the inverse covariance matrix}

\item{kappa_t}{the estimated kappa_t coefficients}

\item{kappa_s}{the estimated kappa_s coefficients}

\item{mu_d}{the fitted values based on document-level variables * estimated Gamma for each document.}

\item{doc}{the sparse matrix representation of the document, with two rows, and columns equal to the number of unique
vocabulary words in the document.}

\item{V}{the size of the vocabulary}

\item{mv}{the baseline log-transformed occurrence rate of each word in the corpus}
}
\value{
The Hessian matrix
}
\description{
Estimates the approximate ELBO needed for the Variational E-step in C++
}
\examples{
\donttest{
library("tm"); library("stm"); library("sts")
temp<-textProcessor(documents=gadarian$open.ended.response,
metadata=gadarian, verbose = FALSE)
out <- prepDocuments(temp$documents, temp$vocab, temp$meta, verbose = FALSE)
X <- model.matrix(~1+out$meta$treatment + out$meta$pid_rep + 
out$meta$treatment * out$meta$pid_rep)[,-1]
X_seed <- as.matrix(out$meta$treatment)
sts_estimate <- sts(X, X_seed, out, numTopics = 3, maxIter = 10)
# for document #1: 
aelbo <- lpbdcpp(alpha_d = sts_estimate$alpha[1,], kappa_t=sts_estimate$kappa$kappa_t, 
kappa_s=sts_estimate$kappa$kappa_s, Sigma_Inv = sts_estimate$sigma_inv, doc = out$documents[[1]], 
V=length(sts_estimate$vocab), mv = sts_estimate$mv, mu_d = sts_estimate$mu[,1])
}
}
\keyword{internal}
