% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.r
\name{str_replace}
\alias{str_replace}
\alias{str_replace_all}
\title{Replace matched patterns in a string.}
\usage{
str_replace(string, pattern, replacement)

str_replace_all(string, pattern, replacement)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described
in \link[stringi:stringi-search-regex]{stringi::stringi-search-regex}. Control options with
\code{\link[=regex]{regex()}}.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[=fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[=coll]{coll()}} which
respects character matching rules for the specified locale.

Match character, word, line and sentence boundaries with
\code{\link[=boundary]{boundary()}}. An empty pattern, "", is equivalent to
\code{boundary("character")}.}

\item{replacement}{A character vector of replacements. Should be either
length one, or the same length as \code{string} or \code{pattern}.
References of the form \code{\1}, \code{\2}, etc will be replaced with
the contents of the respective matched group (created by \code{()}).

To perform multiple replacements in each element of \code{string},
pass a named vector (\code{c(pattern1 = replacement1)}) to
\code{str_replace_all}. Alternatively, pass a function to
\code{replacement}: it will be called once for each match and its
return value will be used to replace the match.

To replace the complete string with \code{NA}, use
\code{replacement = NA_character_}.}
}
\value{
A character vector.
}
\description{
Vectorised over \code{string}, \code{pattern} and \code{replacement}.
}
\examples{
fruits <- c("one apple", "two pears", "three bananas")
str_replace(fruits, "[aeiou]", "-")
str_replace_all(fruits, "[aeiou]", "-")
str_replace_all(fruits, "[aeiou]", toupper)
str_replace_all(fruits, "b", NA_character_)

str_replace(fruits, "([aeiou])", "")
str_replace(fruits, "([aeiou])", "\\\\1\\\\1")
str_replace(fruits, "[aeiou]", c("1", "2", "3"))
str_replace(fruits, c("a", "e", "i"), "-")

# If you want to apply multiple patterns and replacements to the same
# string, pass a named vector to pattern.
fruits \%>\%
  str_c(collapse = "---") \%>\%
  str_replace_all(c("one" = "1", "two" = "2", "three" = "3"))

# Use a function for more sophisticated replacement. This example
# replaces colour names with their hex values.
colours <- str_c("\\\\b", colors(), "\\\\b", collapse="|")
col2hex <- function(col) {
  rgb <- col2rgb(col)
  rgb(rgb["red", ], rgb["green", ], rgb["blue", ], max = 255)
}

x <- c(
  "Roses are red, violets are blue",
  "My favourite colour is green"
)
str_replace_all(x, colours, col2hex)
}
\seealso{
\code{\link[=str_replace_na]{str_replace_na()}} to turn missing values into "NA";
\code{\link[=stri_replace]{stri_replace()}} for the underlying implementation.
}
