% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R, R/string_tools.R
\name{string_ops_alias}
\alias{string_ops_alias}
\alias{string_ops}
\alias{st_ops}
\title{Chains basic operations to character vectors}
\usage{
string_ops_alias(op = NULL, pre_unik = NULL, namespace = NULL)

string_ops(
  x,
  ...,
  op = NULL,
  pre_unik = NULL,
  namespace = NULL,
  envir = parent.frame()
)

st_ops(
  x,
  ...,
  op = NULL,
  pre_unik = NULL,
  namespace = NULL,
  envir = parent.frame()
)
}
\arguments{
\item{op}{Character \strong{vector} or \code{NULL} (default). Character scalar containing the comma separated values
of operations to perform to the vector. The 50+ operations are detailed in the help
page of \code{\link[=string_magic]{string_magic()}}. Note that if this argument is provided, then the values in
\code{...} are ignored.}

\item{pre_unik}{Logical scalar, default is \code{NULL}. Whether to first unique the vector
before applying the possibly costly string operations, and merging back the result.
For very large vectors with repeated values the time gained can be substantial. By
default, this is \code{TRUE} for vector of length 1M or more.}

\item{namespace}{Character scalar or \code{NULL} (default). \strong{Only useful for package developers.}
As a regular end-user you shouldn't care! If your package uses \code{string_magic}, you should care.
It is useful \strong{only} if your package uses 'custom' \code{string_magic} operations, set with
\code{\link[=string_magic_register_fun]{string_magic_register_fun()}} or \code{\link[=string_magic_register_ops]{string_magic_register_ops()}}.

If so pass the name of your package in this argument so that your function can access
the new \code{string_magic} operations defined within your package.}

\item{x}{A character vector. If not a character vector but atomistic (i.e. not a list),
it will be converted to a character vector.}

\item{...}{Character \strong{scalars}. Character scalar containing the comma separated values
of operations to perform to the vector. The 50+ operations are detailed in the help
page of \code{\link[=string_magic]{string_magic()}}.}

\item{envir}{Environment in which to evaluate the interpolations if the flag \code{"magic"} is provided.
Default is \code{parent.frame()}.}
}
\value{
In general it returns a character vector. It may be of a length different from the original
one, depending on the operations performed.
}
\description{
Simple tool to perform multiple operations to character vectors.
}
\details{
This function is a simple wrapper around string_magic. Formally, \code{string_ops(x, "op1, op2")}
is equivalent to \code{string_magic("{op1, op2 ? x}")}.
}
\section{Functions}{
\itemize{
\item \code{string_ops_alias()}: \code{string_ops} alias with custom defaults

\item \code{st_ops()}: Alias to \code{string_ops}

}}
\examples{

# data on car models
cars = row.names(mtcars)

# let's get the brands starting with an "m"
string_ops(cars, "'i/^m'get, x, unik")

# Explainer:
# 'i/^m'get: keeps only the elements starting with an m,
#            i/ is the 'regex-flag' "ignore" to ignore the case
#            ^m means "starts with an m" in regex language
# x: extracts the first pattern. The default pattern is "[[:alnum:]]+"
#    which means an alpha-numeric word
# unik: applies unique() to the vector
# => see help in ?string_magic for more details on the operations


# let's get the 3 largest numbers appearing in the car models
string_ops(cars, "'\\\\d+'x, rm, unik, num, dsort, 3 first")

# Explainer:
# '\\d+'x: extracts the first pattern, the pattern meaning "a succession"
#          of digits in regex language
# rm: removes elements equal to the empty string (default behavior)
# unik: applies unique() to the vector
# num: converts to numeric
# dsort: sorts in decreasing order
# 3 first: keeps only the first three elements

# You can use several character vectors as operations:
string_ops(cars, 
           "'\\\\d+'x, rm, unik",
           "num, dsort, 3 first")

}
\seealso{
Other tools with aliases: 
\code{\link{cat_magic_alias}()},
\code{\link{string_clean_alias}()},
\code{\link{string_magic}()},
\code{\link{string_magic_alias}()},
\code{\link{string_vec_alias}()}
}
\author{
Laurent R. Berge
}
\concept{tools with aliases}
