% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{string_magic_alias}
\alias{string_magic_alias}
\title{Create \code{string_magic} aliases with custom defaults}
\usage{
string_magic_alias(
  .sep = "",
  .vectorize = FALSE,
  .delim = c("{", "}"),
  .last = NULL,
  .post = NULL,
  .default = NULL,
  .nest = FALSE,
  .invisible = FALSE,
  .local_ops = NULL,
  .collapse = NULL,
  .check = TRUE,
  .class = NULL,
  .namespace = NULL
)
}
\arguments{
\item{.sep}{Character scalar, default is the empty string \code{""}. It is used to collapse all
the elements in \code{...} before applying any operation.}

\item{.vectorize}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, Further, elements in \code{...} are
NOT collapsed together, but instead vectorised.}

\item{.delim}{Character vector of length 1 or 2. Default is \code{c("{", "}")}. Defines
the opening and the closing delimiters for interpolation.

If of length 1, it must be of the form: 1) the opening delimiter,
2) a single space, 3) the closing delimiter. Ex: \code{".[ ]"} is equivalent to \code{c(".[", "]")}.
The default value is equivalent to \code{"{ }"}.

[ ]: R:\%20
[", "]: R:\%22,\%20\%22}

\item{.last}{Character scalar, a function, or \code{NULL} (default). If provided and character:
it must be an \code{string_magic} chain of operations of the form \code{"'arg1'op1, op2, etc"}. All these operations
are applied just before returning the vector. If a function,
it will be applied to the resulting vector.}

\item{.post}{Function or \code{NULL} (default). If not \code{NULL}, this function will be applied
after all the processing, just before returning the object. This function can have
extra arguments which will be caught directly in the \code{...} argument of \code{string_magic}.
For example if \code{.post = head}, you can directly pass the argument \code{n = 3} to \code{string_magic}'s arguments.}

\item{.default}{Character scalar or \code{NULL} (default). If provided, it must be
a sequence of \code{string_magic} operations. It will be applied as a default to any interpolation.
Ex: if \code{x = 1:2}, then \code{string_magic("x = {x}", .default = "enum")} leads to "x = 1 and 2",
and is equivalent to \code{string_magic("x = {enum?x}")}. Note that this default operations does
not apply to nested expressions. That is \code{string_magic("{!x{1:2}}", .default = "enum")} leads
to \code{c("x1", "x2")} and NOT \code{"x1 and 2"}.}

\item{.nest}{Logical, default is \code{FALSE}. If \code{TRUE}, it will nest the original string within
interpolation delimiters, so that you can apply operations directly on the string. Example:
\code{string_magic("upper ! hello")} returns "upper ! hello", while \code{string_magic("upper ! hello", .nest = TRUE)}
returns \code{"HELLO"}.}

\item{.invisible}{Logical scalar, default is \code{FALSE}. Whether the object returned should be
invisible (i.e. not printed on the console).}

\item{.local_ops}{Named list or \code{NULL} (default). If provided, it must be a list
of the form \code{list(alias1 = ops1, alias2 = ops2)} where alias is the name of the newly defined
operator an \code{ops} is a character scalar representing the associated string_magic operations.
Ex: \code{list(add = "' + 'collapse")} creates the operation \code{add} which collapses the
string with pluses. All operations created here are only available to the
generated function.}

\item{.collapse}{Character scalar, default is \code{NULL}. If provided, the character vector
that should be returned is collapsed with the value of this argument. This leads
to return a string of length 1.}

\item{.check}{Logical scalar, default is \code{TRUE}. Whether to enable error-handling (i.e.
human readable error messages).
Without error-handling you can save something of the order of 40us. Useful only
in long loops.}

\item{.class}{Character vector representing the class to give to the object returned.
By default it is \code{NULL}. Note that the class \code{string_magic} has a specific \code{print} method, usually
nicer for small vectors (it \code{\link[base:cat]{base::cat()}}s the elements).}

\item{.namespace}{Character scalar or \code{NULL} (default). \strong{Only useful for package developers.}
As a regular end-user you shouldn't care! If your package uses \code{string_magic}, you should care.
It is useful \strong{only} if your package uses 'custom' \code{string_magic} operations, set with
\code{\link[=string_magic_register_fun]{string_magic_register_fun()}} or \code{\link[=string_magic_register_ops]{string_magic_register_ops()}}.}
}
\value{
This function returns a function which will behave in the same way as \code{\link[=string_magic]{string_magic()}}
}
\description{
Utility to easily create \code{string_magic} aliases with custom default
}
\details{
Use this function if you want to change \code{string_magic} default values. For example,
if you want the interpolation to be done with \code{"{{}}"} (instead of \code{{}}) or if you want the
default separation to be the space (instead of the empty string). See the example.
}
\section{Writing a package using \code{string_magic}}{


If you want to use \code{string_magic} in your package and want to make use of custom operations:
\itemize{
\item place any \code{string_magic_register_fun} and \code{string_magic_register_ops} in your \code{.onLoad} function
(see \code{help("onLoad")}). The .onLoad function is run whenever the package is loaded
for the first time. It's a function that you can place anywhere in your \verb{R/*} files
and which looks like this:
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{.onLoad = function(libname, pkgname)\{
  # string_magic custom operations
  string_magic_register_ops("'80|-'fill", "h1")

  invisible()
\}
}\if{html}{\out{</div>}}
\itemize{
\item if you don't want to place the \verb{string_magic_register_*} functions in the .onLoad function,
you can, but then you \strong{must} provide the argument \code{namespace}:
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{string_magic_register_ops("'80|-'fill", "h1", namespace = "myPackageName")
}\if{html}{\out{</div>}}
\itemize{
\item you must create an \code{\link[=string_magic_alias]{string_magic_alias()}} to create an alias to \code{\link[=string_magic]{string_magic()}} and use the
argument \code{.namespace = "myPackageName"}. Use this opportunity to change the
defaults if you wish. You can even override the \code{string_magic} function:
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# creating an alias with the same name + changing the delimiter
string_magic = stringmagic::string_magic_alias(.namespace = "myPackageName", .delim = "\{\{ \}\}")
}\if{html}{\out{</div>}}
}

\examples{

# we create the function sma2 with different defaults
sma2 = string_magic_alias(.delim = ".[ ]", .sep = " ", .class = "string_magic")

person = "john doe"
sma2("Hello", ".[title ? person]")

# you can use the arguments whose default has been changed
sma2("Hello", ".[title ? person]", .sep = ": ")



}
\seealso{
Other related to string_magic: 
\code{\link{string_magic_register_fun}()}

Other tools with aliases: 
\code{\link{cat_magic_alias}()},
\code{\link{string_clean_alias}()},
\code{\link{string_magic}()},
\code{\link{string_ops_alias}()},
\code{\link{string_vec_alias}()}
}
\author{
Laurent Berge
}
\concept{related to string_magic}
\concept{tools with aliases}
