% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding_conversion.R
\name{stri_enc_toascii}
\alias{stri_enc_toascii}
\title{Convert To ASCII}
\usage{
stri_enc_toascii(str)
}
\arguments{
\item{str}{a character vector to be converted}
}
\value{
Returns a character vector.
}
\description{
This function converts input strings to ASCII,
i.e. to character strings consisting of bytes not greater than 127.
}
\details{
All code points greater than 127 are replaced with ASCII SUBSTITUTE
CHARACTER (0x1A).
\R encoding declarations are always used to determine
which encoding is assumed for each input, see \code{\link{stri_enc_mark}}.
In incorrect byte sequences are found in UTF-8 byte
streams, a warning is generated.

A \code{bytes}-marked string is assumed to be represented
by a 8-bit encoding such that it has ASCII as its subset
(a common assumption in R itself).

Note that the SUBSTITUTE CHARACTER (\code{\\x1a == \\032}) may be interpreted
as ASCII missing value for single characters.
}
\seealso{
Other encoding_conversion: \code{\link{stri_enc_fromutf32}},
  \code{\link{stri_enc_tonative}},
  \code{\link{stri_enc_toutf32}},
  \code{\link{stri_enc_toutf8}}, \code{\link{stri_encode}},
  \code{\link{stringi-encoding}}
}

