/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.github.javacliparser.MultiChoiceOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import moa.AbstractMOAObject;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.MultiClassClassifier;
import moa.classifiers.bayes.NaiveBayes;
import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.DiscreteAttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.NullAttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.NumericAttributeClassObserver;
import moa.classifiers.core.conditionaltests.InstanceConditionalTest;
import moa.classifiers.core.conditionaltests.NominalAttributeBinaryTest;
import moa.classifiers.core.conditionaltests.NominalAttributeMultiwayTest;
import moa.classifiers.core.conditionaltests.NumericAttributeBinaryTest;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.SizeOf;
import moa.core.StringUtils;
import moa.core.Utils;
import moa.options.ClassOption;

public class EFDT
extends AbstractClassifier
implements MultiClassClassifier {
    private static final long serialVersionUID = 2L;
    public IntOption reEvalPeriodOption = new IntOption("reevaluationPeriod", 'R', "The number of instances an internal node should observe between re-evaluation attempts.", 2000, 0, Integer.MAX_VALUE);
    public IntOption maxByteSizeOption = new IntOption("maxByteSize", 'm', "Maximum memory consumed by the tree.", 0x2000000, 0, Integer.MAX_VALUE);
    public ClassOption numericEstimatorOption = new ClassOption("numericEstimator", 'n', "Numeric estimator to use.", NumericAttributeClassObserver.class, "GaussianNumericAttributeClassObserver");
    public ClassOption nominalEstimatorOption = new ClassOption("nominalEstimator", 'd', "Nominal estimator to use.", DiscreteAttributeClassObserver.class, "NominalAttributeClassObserver");
    public IntOption memoryEstimatePeriodOption = new IntOption("memoryEstimatePeriod", 'e', "How many instances between memory consumption checks.", 1000000, 0, Integer.MAX_VALUE);
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "The number of instances a leaf should observe between split attempts.", 200, 0, Integer.MAX_VALUE);
    public ClassOption splitCriterionOption = new ClassOption("splitCriterion", 's', "Split criterion to use.", SplitCriterion.class, "InfoGainSplitCriterion");
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "The allowable error in split decision, values closer to 0 will take longer to decide.", 1.0E-7, 0.0, 1.0);
    public FloatOption tieThresholdOption = new FloatOption("tieThreshold", 't', "Threshold below which a split will be forced to break ties.", 0.05, 0.0, 1.0);
    public FlagOption binarySplitsOption = new FlagOption("binarySplits", 'b', "Only allow binary splits.");
    public FlagOption stopMemManagementOption = new FlagOption("stopMemManagement", 'z', "Stop growing as soon as memory limit is hit.");
    public FlagOption removePoorAttsOption = new FlagOption("removePoorAtts", 'r', "Disable poor attributes.");
    public FlagOption noPrePruneOption = new FlagOption("noPrePrune", 'p', "Disable pre-pruning.");
    public MultiChoiceOption leafpredictionOption = new MultiChoiceOption("leafprediction", 'l', "Leaf prediction to use.", new String[]{"MC", "NB", "NBAdaptive"}, new String[]{"Majority class", "Naive Bayes", "Naive Bayes Adaptive"}, 2);
    public IntOption nbThresholdOption = new IntOption("nbThreshold", 'q', "The number of instances a leaf should observe before permitting Naive Bayes.", 0, 0, Integer.MAX_VALUE);
    protected Node treeRoot = null;
    protected int decisionNodeCount;
    protected int activeLeafNodeCount;
    protected int inactiveLeafNodeCount;
    protected double inactiveLeafByteSizeEstimate;
    protected double activeLeafByteSizeEstimate;
    protected double byteSizeEstimateOverheadFraction;
    protected boolean growthAllowed;
    protected int numInstances = 0;
    protected int splitCount = 0;

    @Override
    public String getPurposeString() {
        return "Hoeffding Tree or VFDT.";
    }

    public int calcByteSize() {
        int size = (int)SizeOf.sizeOf(this);
        if (this.treeRoot != null) {
            size += this.treeRoot.calcByteSizeIncludingSubtree();
        }
        return size;
    }

    @Override
    public int measureByteSize() {
        return this.calcByteSize();
    }

    @Override
    public void resetLearningImpl() {
        this.treeRoot = null;
        this.decisionNodeCount = 0;
        this.activeLeafNodeCount = 0;
        this.inactiveLeafNodeCount = 0;
        this.inactiveLeafByteSizeEstimate = 0.0;
        this.activeLeafByteSizeEstimate = 0.0;
        this.byteSizeEstimateOverheadFraction = 1.0;
        this.growthAllowed = true;
        if (this.leafpredictionOption.getChosenIndex() > 0) {
            this.removePoorAttsOption = null;
        }
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        if (this.treeRoot != null) {
            FoundNode foundNode = this.treeRoot.filterInstanceToLeaf(inst, null, -1);
            Node leafNode = foundNode.node;
            if (leafNode == null) {
                leafNode = foundNode.parent;
            }
            return leafNode.getClassVotes(inst, this);
        }
        int numClasses = inst.dataset().numClasses();
        return new double[numClasses];
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        FoundNode[] learningNodes = this.findLearningNodes();
        return new Measurement[]{new Measurement("tree size (nodes)", this.decisionNodeCount + this.activeLeafNodeCount + this.inactiveLeafNodeCount), new Measurement("tree size (leaves)", learningNodes.length), new Measurement("active learning leaves", this.activeLeafNodeCount), new Measurement("tree depth", this.measureTreeDepth()), new Measurement("active leaf byte size estimate", this.activeLeafByteSizeEstimate), new Measurement("inactive leaf byte size estimate", this.inactiveLeafByteSizeEstimate), new Measurement("byte size estimate overhead", this.byteSizeEstimateOverheadFraction), new Measurement("splits", this.splitCount)};
    }

    public int measureTreeDepth() {
        if (this.treeRoot != null) {
            return this.treeRoot.subtreeDepth();
        }
        return 0;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        this.treeRoot.describeSubtree(this, out, indent);
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    public static double computeHoeffdingBound(double range, double confidence, double n) {
        return Math.sqrt(range * range * Math.log(1.0 / confidence) / (2.0 * n));
    }

    protected AttributeClassObserver newNominalClassObserver() {
        AttributeClassObserver nominalClassObserver = (AttributeClassObserver)this.getPreparedClassOption(this.nominalEstimatorOption);
        return (AttributeClassObserver)nominalClassObserver.copy();
    }

    protected AttributeClassObserver newNumericClassObserver() {
        AttributeClassObserver numericClassObserver = (AttributeClassObserver)this.getPreparedClassOption(this.numericEstimatorOption);
        return (AttributeClassObserver)numericClassObserver.copy();
    }

    public void enforceTrackerLimit() {
        if (this.inactiveLeafNodeCount > 0 || ((double)this.activeLeafNodeCount * this.activeLeafByteSizeEstimate + (double)this.inactiveLeafNodeCount * this.inactiveLeafByteSizeEstimate) * this.byteSizeEstimateOverheadFraction > (double)this.maxByteSizeOption.getValue()) {
            int i;
            if (this.stopMemManagementOption.isSet()) {
                this.growthAllowed = false;
                return;
            }
            FoundNode[] learningNodes = this.findLearningNodes();
            Arrays.sort(learningNodes, new Comparator<FoundNode>(){

                @Override
                public int compare(FoundNode fn1, FoundNode fn2) {
                    return Double.compare(fn1.node.calculatePromise(), fn2.node.calculatePromise());
                }
            });
            int maxActive = 0;
            while (maxActive < learningNodes.length) {
                if (!(((double)(++maxActive) * this.activeLeafByteSizeEstimate + (double)(learningNodes.length - maxActive) * this.inactiveLeafByteSizeEstimate) * this.byteSizeEstimateOverheadFraction > (double)this.maxByteSizeOption.getValue())) continue;
                --maxActive;
                break;
            }
            int cutoff = learningNodes.length - maxActive;
            for (i = 0; i < cutoff; ++i) {
                if (!(learningNodes[i].node instanceof ActiveLearningNode)) continue;
                this.deactivateLearningNode((ActiveLearningNode)learningNodes[i].node, learningNodes[i].parent, learningNodes[i].parentBranch);
            }
            for (i = cutoff; i < learningNodes.length; ++i) {
                if (!(learningNodes[i].node instanceof InactiveLearningNode)) continue;
                this.activateLearningNode((InactiveLearningNode)learningNodes[i].node, learningNodes[i].parent, learningNodes[i].parentBranch);
            }
        }
    }

    public void estimateModelByteSizes() {
        FoundNode[] learningNodes = this.findLearningNodes();
        long totalActiveSize = 0L;
        long totalInactiveSize = 0L;
        for (FoundNode foundNode : learningNodes) {
            if (foundNode.node instanceof ActiveLearningNode) {
                totalActiveSize += SizeOf.fullSizeOf(foundNode.node);
                continue;
            }
            totalInactiveSize += SizeOf.fullSizeOf(foundNode.node);
        }
        if (totalActiveSize > 0L) {
            this.activeLeafByteSizeEstimate = (double)totalActiveSize / (double)this.activeLeafNodeCount;
        }
        if (totalInactiveSize > 0L) {
            this.inactiveLeafByteSizeEstimate = (double)totalInactiveSize / (double)this.inactiveLeafNodeCount;
        }
        int actualModelSize = this.measureByteSize();
        double estimatedModelSize = (double)this.activeLeafNodeCount * this.activeLeafByteSizeEstimate + (double)this.inactiveLeafNodeCount * this.inactiveLeafByteSizeEstimate;
        this.byteSizeEstimateOverheadFraction = (double)actualModelSize / estimatedModelSize;
        if (actualModelSize > this.maxByteSizeOption.getValue()) {
            this.enforceTrackerLimit();
        }
    }

    public void deactivateAllLeaves() {
        FoundNode[] learningNodes;
        for (FoundNode learningNode : learningNodes = this.findLearningNodes()) {
            if (!(learningNode.node instanceof ActiveLearningNode)) continue;
            this.deactivateLearningNode((ActiveLearningNode)learningNode.node, learningNode.parent, learningNode.parentBranch);
        }
    }

    protected void deactivateLearningNode(ActiveLearningNode toDeactivate, SplitNode parent, int parentBranch) {
        InactiveLearningNode newLeaf = new InactiveLearningNode(toDeactivate.getObservedClassDistribution());
        if (parent == null) {
            this.treeRoot = newLeaf;
        } else {
            parent.setChild(parentBranch, newLeaf);
        }
        --this.activeLeafNodeCount;
        ++this.inactiveLeafNodeCount;
    }

    protected void activateLearningNode(InactiveLearningNode toActivate, SplitNode parent, int parentBranch) {
        LearningNode newLeaf = this.newLearningNode(toActivate.getObservedClassDistribution());
        if (parent == null) {
            this.treeRoot = newLeaf;
        } else {
            parent.setChild(parentBranch, newLeaf);
        }
        ++this.activeLeafNodeCount;
        --this.inactiveLeafNodeCount;
    }

    protected FoundNode[] findLearningNodes() {
        LinkedList<FoundNode> foundList = new LinkedList<FoundNode>();
        this.findLearningNodes(this.treeRoot, null, -1, foundList);
        return foundList.toArray(new FoundNode[foundList.size()]);
    }

    protected void findLearningNodes(Node node, SplitNode parent, int parentBranch, List<FoundNode> found) {
        if (node != null) {
            if (node instanceof LearningNode) {
                found.add(new FoundNode(node, parent, parentBranch));
            }
            if (node instanceof SplitNode) {
                SplitNode splitNode = (SplitNode)node;
                for (int i = 0; i < splitNode.numChildren(); ++i) {
                    this.findLearningNodes(splitNode.getChild(i), splitNode, i, found);
                }
            }
        }
    }

    protected void attemptToSplit(ActiveLearningNode node, SplitNode parent, int parentIndex) {
        if (!node.observedClassDistributionIsPure()) {
            node.addToSplitAttempts(1);
            SplitCriterion splitCriterion = (SplitCriterion)this.getPreparedClassOption(this.splitCriterionOption);
            Object[] bestSplitSuggestions = node.getBestSplitSuggestions(splitCriterion, this);
            Arrays.sort(bestSplitSuggestions);
            boolean shouldSplit = false;
            for (Object bestSplitSuggestion : bestSplitSuggestions) {
                double currentSum;
                if (((AttributeSplitSuggestion)bestSplitSuggestion).splitTest != null) {
                    if (!node.getInfogainSum().containsKey(((AttributeSplitSuggestion)bestSplitSuggestion).splitTest.getAttsTestDependsOn()[0])) {
                        node.getInfogainSum().put(((AttributeSplitSuggestion)bestSplitSuggestion).splitTest.getAttsTestDependsOn()[0], 0.0);
                    }
                    currentSum = node.getInfogainSum().get(((AttributeSplitSuggestion)bestSplitSuggestion).splitTest.getAttsTestDependsOn()[0]);
                    node.getInfogainSum().put(((AttributeSplitSuggestion)bestSplitSuggestion).splitTest.getAttsTestDependsOn()[0], currentSum + ((AttributeSplitSuggestion)bestSplitSuggestion).merit);
                    continue;
                }
                currentSum = node.getInfogainSum().get(-1);
                node.getInfogainSum().put(-1, Math.max(0.0, currentSum + ((AttributeSplitSuggestion)bestSplitSuggestion).merit));
                assert (node.getInfogainSum().get(-1) >= 0.0) : "Negative infogain shouldn't be possible here.";
            }
            if (bestSplitSuggestions.length < 2) {
                shouldSplit = bestSplitSuggestions.length > 0;
            } else {
                double hoeffdingBound = EFDT.computeHoeffdingBound(splitCriterion.getRangeOfMerit(node.getObservedClassDistribution()), this.splitConfidenceOption.getValue(), node.getWeightSeen());
                Object bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
                double currentAverageMerit = node.getInfogainSum().get(-1) / (double)node.getNumSplitAttempts();
                double bestSuggestionAverageMerit = ((AttributeSplitSuggestion)bestSuggestion).splitTest == null ? node.getInfogainSum().get(-1) / (double)node.getNumSplitAttempts() : node.getInfogainSum().get(((AttributeSplitSuggestion)bestSuggestion).splitTest.getAttsTestDependsOn()[0]) / (double)node.getNumSplitAttempts();
                if (((AttributeSplitSuggestion)bestSuggestion).merit < 1.0E-10) {
                    shouldSplit = false;
                } else if (bestSuggestionAverageMerit - currentAverageMerit > hoeffdingBound || hoeffdingBound < this.tieThresholdOption.getValue()) {
                    if (bestSuggestionAverageMerit - currentAverageMerit < hoeffdingBound) {
                        // empty if block
                    }
                    shouldSplit = true;
                }
                if (shouldSplit) {
                    for (Integer i : node.usedNominalAttributes) {
                        if (((AttributeSplitSuggestion)bestSuggestion).splitTest.getAttsTestDependsOn()[0] != i) continue;
                        shouldSplit = false;
                        break;
                    }
                }
                if (this.removePoorAttsOption != null && this.removePoorAttsOption.isSet()) {
                    int[] splitAtts;
                    HashSet<Integer> poorAtts = new HashSet<Integer>();
                    for (Object bestSplitSuggestion : bestSplitSuggestions) {
                        if (((AttributeSplitSuggestion)bestSplitSuggestion).splitTest == null || (splitAtts = ((AttributeSplitSuggestion)bestSplitSuggestion).splitTest.getAttsTestDependsOn()).length != 1 || !(((AttributeSplitSuggestion)bestSuggestion).merit - ((AttributeSplitSuggestion)bestSplitSuggestion).merit > hoeffdingBound)) continue;
                        poorAtts.add(splitAtts[0]);
                    }
                    for (Object bestSplitSuggestion : bestSplitSuggestions) {
                        if (((AttributeSplitSuggestion)bestSplitSuggestion).splitTest == null || (splitAtts = ((AttributeSplitSuggestion)bestSplitSuggestion).splitTest.getAttsTestDependsOn()).length != 1 || !(((AttributeSplitSuggestion)bestSuggestion).merit - ((AttributeSplitSuggestion)bestSplitSuggestion).merit < hoeffdingBound)) continue;
                        poorAtts.remove(splitAtts[0]);
                    }
                    Iterator iterator = poorAtts.iterator();
                    while (iterator.hasNext()) {
                        int poorAtt = (Integer)iterator.next();
                        node.disableAttribute(poorAtt);
                    }
                }
            }
            if (shouldSplit) {
                ++this.splitCount;
                Object splitDecision = bestSplitSuggestions[bestSplitSuggestions.length - 1];
                if (((AttributeSplitSuggestion)splitDecision).splitTest == null) {
                    this.deactivateLearningNode(node, parent, parentIndex);
                } else {
                    SplitNode newSplit = this.newSplitNode(((AttributeSplitSuggestion)splitDecision).splitTest, node.getObservedClassDistribution(), ((AttributeSplitSuggestion)splitDecision).numSplits());
                    ((EFDTSplitNode)newSplit).attributeObservers = node.attributeObservers;
                    newSplit.setInfogainSum(node.getInfogainSum());
                    for (int i = 0; i < ((AttributeSplitSuggestion)splitDecision).numSplits(); ++i) {
                        double[] j = ((AttributeSplitSuggestion)splitDecision).resultingClassDistributionFromSplit(i);
                        LearningNode newChild = this.newLearningNode(((AttributeSplitSuggestion)splitDecision).resultingClassDistributionFromSplit(i));
                        if (((AttributeSplitSuggestion)splitDecision).splitTest.getClass() == NominalAttributeBinaryTest.class || ((AttributeSplitSuggestion)splitDecision).splitTest.getClass() == NominalAttributeMultiwayTest.class) {
                            newChild.usedNominalAttributes = new ArrayList<Integer>(node.usedNominalAttributes);
                            newChild.usedNominalAttributes.add(((AttributeSplitSuggestion)splitDecision).splitTest.getAttsTestDependsOn()[0]);
                        }
                        ((EFDTSplitNode)newSplit).setChild(i, newChild);
                    }
                    --this.activeLeafNodeCount;
                    ++this.decisionNodeCount;
                    this.activeLeafNodeCount += ((AttributeSplitSuggestion)splitDecision).numSplits();
                    if (parent == null) {
                        this.treeRoot = newSplit;
                    } else {
                        parent.setChild(parentIndex, newSplit);
                    }
                }
                this.enforceTrackerLimit();
            }
        }
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (this.treeRoot == null) {
            this.treeRoot = this.newLearningNode();
            ((EFDTNode)((Object)this.treeRoot)).setRoot(true);
            this.activeLeafNodeCount = 1;
        }
        FoundNode foundNode = this.treeRoot.filterInstanceToLeaf(inst, null, -1);
        Node leafNode = foundNode.node;
        if (leafNode == null) {
            leafNode = this.newLearningNode();
            foundNode.parent.setChild(foundNode.parentBranch, leafNode);
            ++this.activeLeafNodeCount;
        }
        ((EFDTNode)((Object)this.treeRoot)).learnFromInstance(inst, this, null, -1);
        ++this.numInstances;
    }

    protected LearningNode newLearningNode() {
        return new EFDTLearningNode(new double[0]);
    }

    protected LearningNode newLearningNode(double[] initialClassObservations) {
        return new EFDTLearningNode(initialClassObservations);
    }

    protected SplitNode newSplitNode(InstanceConditionalTest splitTest, double[] classObservations, int size) {
        return new EFDTSplitNode(splitTest, classObservations, size);
    }

    protected SplitNode newSplitNode(InstanceConditionalTest splitTest, double[] classObservations) {
        return new EFDTSplitNode(splitTest, classObservations);
    }

    private int argmax(double[] array) {
        double max = array[0];
        int maxarg = 0;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] > max)) continue;
            max = array[i];
            maxarg = i;
        }
        return maxarg;
    }

    static class VFDT
    extends EFDT {
        VFDT() {
        }

        @Override
        protected void attemptToSplit(ActiveLearningNode node, SplitNode parent, int parentIndex) {
            if (!node.observedClassDistributionIsPure()) {
                SplitCriterion splitCriterion = (SplitCriterion)this.getPreparedClassOption(this.splitCriterionOption);
                Object[] bestSplitSuggestions = node.getBestSplitSuggestions(splitCriterion, this);
                Arrays.sort(bestSplitSuggestions);
                boolean shouldSplit = false;
                for (int i = 0; i < bestSplitSuggestions.length; ++i) {
                    double currentSum;
                    node.addToSplitAttempts(1);
                    if (((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest != null) {
                        if (!node.getInfogainSum().containsKey(((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest.getAttsTestDependsOn()[0])) {
                            node.getInfogainSum().put(((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest.getAttsTestDependsOn()[0], 0.0);
                        }
                        currentSum = node.getInfogainSum().get(((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest.getAttsTestDependsOn()[0]);
                        node.getInfogainSum().put(((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest.getAttsTestDependsOn()[0], currentSum + ((AttributeSplitSuggestion)bestSplitSuggestions[i]).merit);
                        continue;
                    }
                    currentSum = node.getInfogainSum().get(-1);
                    node.getInfogainSum().put(-1, currentSum + Math.max(0.0, ((AttributeSplitSuggestion)bestSplitSuggestions[i]).merit));
                    assert (node.getInfogainSum().get(-1) >= 0.0) : "Negative infogain shouldn't be possible here.";
                }
                if (bestSplitSuggestions.length < 2) {
                    shouldSplit = bestSplitSuggestions.length > 0;
                } else {
                    double hoeffdingBound = VFDT.computeHoeffdingBound(splitCriterion.getRangeOfMerit(node.getObservedClassDistribution()), this.splitConfidenceOption.getValue(), node.getWeightSeen());
                    Object bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
                    Object secondBestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 2];
                    double bestSuggestionAverageMerit = 0.0;
                    double secondBestSuggestionAverageMerit = 0.0;
                    bestSuggestionAverageMerit = ((AttributeSplitSuggestion)bestSuggestion).splitTest == null ? node.getInfogainSum().get(-1) / (double)node.getNumSplitAttempts() : node.getInfogainSum().get(((AttributeSplitSuggestion)bestSuggestion).splitTest.getAttsTestDependsOn()[0]) / (double)node.getNumSplitAttempts();
                    secondBestSuggestionAverageMerit = ((AttributeSplitSuggestion)secondBestSuggestion).splitTest == null ? node.getInfogainSum().get(-1) / (double)node.getNumSplitAttempts() : node.getInfogainSum().get(((AttributeSplitSuggestion)secondBestSuggestion).splitTest.getAttsTestDependsOn()[0]) / (double)node.getNumSplitAttempts();
                    if (((AttributeSplitSuggestion)bestSuggestion).merit < 1.0E-10) {
                        shouldSplit = false;
                    } else if (bestSuggestionAverageMerit - secondBestSuggestionAverageMerit > hoeffdingBound || hoeffdingBound < this.tieThresholdOption.getValue()) {
                        shouldSplit = true;
                    }
                    if (shouldSplit) {
                        for (Integer i : node.usedNominalAttributes) {
                            if (((AttributeSplitSuggestion)bestSuggestion).splitTest.getAttsTestDependsOn()[0] != i) continue;
                            shouldSplit = false;
                            break;
                        }
                    }
                    if (this.removePoorAttsOption != null && this.removePoorAttsOption.isSet()) {
                        int[] splitAtts;
                        int i;
                        HashSet<Integer> poorAtts = new HashSet<Integer>();
                        for (i = 0; i < bestSplitSuggestions.length; ++i) {
                            if (((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest == null || (splitAtts = ((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest.getAttsTestDependsOn()).length != 1 || !(((AttributeSplitSuggestion)bestSuggestion).merit - ((AttributeSplitSuggestion)bestSplitSuggestions[i]).merit > hoeffdingBound)) continue;
                            poorAtts.add(new Integer(splitAtts[0]));
                        }
                        for (i = 0; i < bestSplitSuggestions.length; ++i) {
                            if (((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest == null || (splitAtts = ((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest.getAttsTestDependsOn()).length != 1 || !(((AttributeSplitSuggestion)bestSuggestion).merit - ((AttributeSplitSuggestion)bestSplitSuggestions[i]).merit < hoeffdingBound)) continue;
                            poorAtts.remove(new Integer(splitAtts[0]));
                        }
                        Iterator iterator = poorAtts.iterator();
                        while (iterator.hasNext()) {
                            int poorAtt = (Integer)iterator.next();
                            node.disableAttribute(poorAtt);
                        }
                    }
                }
                if (shouldSplit) {
                    ++this.splitCount;
                    Object splitDecision = bestSplitSuggestions[bestSplitSuggestions.length - 1];
                    if (((AttributeSplitSuggestion)splitDecision).splitTest == null) {
                        this.deactivateLearningNode(node, parent, parentIndex);
                    } else {
                        SplitNode newSplit = this.newSplitNode(((AttributeSplitSuggestion)splitDecision).splitTest, node.getObservedClassDistribution(), ((AttributeSplitSuggestion)splitDecision).numSplits());
                        for (int i = 0; i < ((AttributeSplitSuggestion)splitDecision).numSplits(); ++i) {
                            double[] j = ((AttributeSplitSuggestion)splitDecision).resultingClassDistributionFromSplit(i);
                            LearningNode newChild = this.newLearningNode(((AttributeSplitSuggestion)splitDecision).resultingClassDistributionFromSplit(i));
                            if (((AttributeSplitSuggestion)splitDecision).splitTest.getClass() == NominalAttributeBinaryTest.class || ((AttributeSplitSuggestion)splitDecision).splitTest.getClass() == NominalAttributeMultiwayTest.class) {
                                newChild.usedNominalAttributes = new ArrayList<Integer>(node.usedNominalAttributes);
                                newChild.usedNominalAttributes.add(((AttributeSplitSuggestion)splitDecision).splitTest.getAttsTestDependsOn()[0]);
                            }
                            newSplit.setChild(i, newChild);
                        }
                        --this.activeLeafNodeCount;
                        ++this.decisionNodeCount;
                        this.activeLeafNodeCount += ((AttributeSplitSuggestion)splitDecision).numSplits();
                        if (parent == null) {
                            this.treeRoot = newSplit;
                        } else {
                            parent.setChild(parentIndex, newSplit);
                        }
                    }
                    this.enforceTrackerLimit();
                }
            }
        }

        @Override
        protected LearningNode newLearningNode() {
            return this.newLearningNode(new double[0]);
        }

        @Override
        protected LearningNode newLearningNode(double[] initialClassObservations) {
            int predictionOption = this.leafpredictionOption.getChosenIndex();
            ActiveLearningNode ret = predictionOption == 0 ? new ActiveLearningNode(initialClassObservations) : (predictionOption == 1 ? new LearningNodeNB(initialClassObservations) : new LearningNodeNBAdaptive(initialClassObservations));
            return ret;
        }

        @Override
        protected SplitNode newSplitNode(InstanceConditionalTest splitTest, double[] classObservations, int size) {
            return new SplitNode(splitTest, classObservations, size);
        }

        @Override
        protected SplitNode newSplitNode(InstanceConditionalTest splitTest, double[] classObservations) {
            return new SplitNode(splitTest, classObservations);
        }

        @Override
        public void trainOnInstanceImpl(Instance inst) {
            if (this.treeRoot == null) {
                this.treeRoot = this.newLearningNode();
                this.activeLeafNodeCount = 1;
            }
            FoundNode foundNode = this.treeRoot.filterInstanceToLeaf(inst, null, -1);
            Node leafNode = foundNode.node;
            if (leafNode == null) {
                leafNode = this.newLearningNode();
                foundNode.parent.setChild(foundNode.parentBranch, leafNode);
                ++this.activeLeafNodeCount;
            }
            if (leafNode instanceof LearningNode) {
                LearningNode learningNode = (LearningNode)leafNode;
                learningNode.learnFromInstance(inst, this);
                if (this.growthAllowed && learningNode instanceof ActiveLearningNode) {
                    ActiveLearningNode activeLearningNode = (ActiveLearningNode)learningNode;
                    double weightSeen = activeLearningNode.getWeightSeen();
                    if (activeLearningNode.nodeTime % this.gracePeriodOption.getValue() == 0) {
                        this.attemptToSplit(activeLearningNode, foundNode.parent, foundNode.parentBranch);
                        activeLearningNode.setWeightSeenAtLastSplitEvaluation(weightSeen);
                    }
                }
            }
            if (this.trainingWeightSeenByModel % (double)this.memoryEstimatePeriodOption.getValue() == 0.0) {
                this.estimateModelByteSizes();
            }
            ++this.numInstances;
        }
    }

    public static class LearningNodeNBAdaptive
    extends LearningNodeNB {
        private static final long serialVersionUID = 1L;
        protected double mcCorrectWeight = 0.0;
        protected double nbCorrectWeight = 0.0;

        public LearningNodeNBAdaptive(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        @Override
        public void learnFromInstance(Instance inst, EFDT ht) {
            int trueClass = (int)inst.classValue();
            if (this.observedClassDistribution.maxIndex() == trueClass) {
                this.mcCorrectWeight += inst.weight();
            }
            if (Utils.maxIndex(NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers)) == trueClass) {
                this.nbCorrectWeight += inst.weight();
            }
            super.learnFromInstance(inst, ht);
        }

        @Override
        public double[] getClassVotes(Instance inst, EFDT ht) {
            if (this.mcCorrectWeight > this.nbCorrectWeight) {
                return this.observedClassDistribution.getArrayCopy();
            }
            return NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers);
        }
    }

    public static class LearningNodeNB
    extends ActiveLearningNode {
        private static final long serialVersionUID = 1L;

        public LearningNodeNB(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        @Override
        public double[] getClassVotes(Instance inst, EFDT ht) {
            if (this.getWeightSeen() >= (double)ht.nbThresholdOption.getValue()) {
                return NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers);
            }
            return super.getClassVotes(inst, ht);
        }

        @Override
        public void disableAttribute(int attIndex) {
        }
    }

    public static class ActiveLearningNode
    extends LearningNode {
        private static final long serialVersionUID = 1L;
        protected double weightSeenAtLastSplitEvaluation;
        protected AutoExpandVector<AttributeClassObserver> attributeObservers = new AutoExpandVector();
        protected boolean isInitialized = false;

        public ActiveLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
            this.weightSeenAtLastSplitEvaluation = this.getWeightSeen();
        }

        @Override
        public int calcByteSize() {
            return super.calcByteSize() + (int)SizeOf.fullSizeOf(this.attributeObservers);
        }

        @Override
        public void learnFromInstance(Instance inst, EFDT ht) {
            ++this.nodeTime;
            if (this.isInitialized) {
                this.attributeObservers = new AutoExpandVector(inst.numAttributes());
                this.isInitialized = true;
            }
            this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                int instAttIndex = EFDT.modelAttIndexToInstanceAttIndex(i, inst);
                AttributeClassObserver obs = this.attributeObservers.get(i);
                if (obs == null) {
                    obs = inst.attribute(instAttIndex).isNominal() ? ht.newNominalClassObserver() : ht.newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                obs.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
            }
        }

        public double getWeightSeen() {
            return this.observedClassDistribution.sumOfValues();
        }

        public double getWeightSeenAtLastSplitEvaluation() {
            return this.weightSeenAtLastSplitEvaluation;
        }

        public void setWeightSeenAtLastSplitEvaluation(double weight) {
            this.weightSeenAtLastSplitEvaluation = weight;
        }

        public AttributeSplitSuggestion[] getBestSplitSuggestions(SplitCriterion criterion, EFDT ht) {
            LinkedList<AttributeSplitSuggestion> bestSuggestions = new LinkedList<AttributeSplitSuggestion>();
            double[] preSplitDist = this.observedClassDistribution.getArrayCopy();
            if (!ht.noPrePruneOption.isSet()) {
                bestSuggestions.add(new AttributeSplitSuggestion(null, new double[0][], criterion.getMeritOfSplit(preSplitDist, new double[][]{preSplitDist})));
            }
            for (int i = 0; i < this.attributeObservers.size(); ++i) {
                AttributeSplitSuggestion bestSuggestion;
                AttributeClassObserver obs = this.attributeObservers.get(i);
                if (obs == null || (bestSuggestion = obs.getBestEvaluatedSplitSuggestion(criterion, preSplitDist, i, ht.binarySplitsOption.isSet())) == null) continue;
                bestSuggestions.add(bestSuggestion);
            }
            return bestSuggestions.toArray(new AttributeSplitSuggestion[bestSuggestions.size()]);
        }

        public void disableAttribute(int attIndex) {
            this.attributeObservers.set(attIndex, new NullAttributeClassObserver());
        }
    }

    public static class InactiveLearningNode
    extends LearningNode {
        private static final long serialVersionUID = 1L;

        public InactiveLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        @Override
        public void learnFromInstance(Instance inst, EFDT ht) {
            this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
        }
    }

    public class EFDTLearningNode
    extends LearningNodeNBAdaptive
    implements EFDTNode {
        private boolean isRoot;
        private EFDTSplitNode parent;
        private static final long serialVersionUID = -2525042202040084035L;

        public EFDTLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
            this.parent = null;
        }

        @Override
        public boolean isRoot() {
            return this.isRoot;
        }

        @Override
        public void setRoot(boolean isRoot) {
            this.isRoot = isRoot;
        }

        @Override
        public void learnFromInstance(Instance inst, EFDT ht) {
            super.learnFromInstance(inst, ht);
        }

        @Override
        public void learnFromInstance(Instance inst, EFDT ht, EFDTSplitNode parent, int parentBranch) {
            this.learnFromInstance(inst, ht);
            if (ht.growthAllowed) {
                EFDTLearningNode activeLearningNode = this;
                double weightSeen = activeLearningNode.getWeightSeen();
                if (activeLearningNode.nodeTime % ht.gracePeriodOption.getValue() == 0) {
                    EFDT.this.attemptToSplit(activeLearningNode, parent, parentBranch);
                    activeLearningNode.setWeightSeenAtLastSplitEvaluation(weightSeen);
                }
            }
        }

        @Override
        public void setParent(EFDTSplitNode parent) {
            this.parent = parent;
        }

        @Override
        public EFDTSplitNode getParent() {
            return this.parent;
        }
    }

    public static abstract class LearningNode
    extends Node {
        private static final long serialVersionUID = 1L;

        public LearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        public abstract void learnFromInstance(Instance var1, EFDT var2);
    }

    public class EFDTSplitNode
    extends SplitNode
    implements EFDTNode {
        private boolean isRoot;
        private EFDTSplitNode parent;
        private static final long serialVersionUID = 1L;
        protected AutoExpandVector<AttributeClassObserver> attributeObservers;

        public EFDTSplitNode(InstanceConditionalTest splitTest, double[] classObservations, int size) {
            super(splitTest, classObservations, size);
            this.parent = null;
        }

        public EFDTSplitNode(InstanceConditionalTest splitTest, double[] classObservations) {
            super(splitTest, classObservations);
            this.parent = null;
        }

        @Override
        public boolean isRoot() {
            return this.isRoot;
        }

        @Override
        public void setRoot(boolean isRoot) {
            this.isRoot = isRoot;
        }

        public void killSubtree(EFDT ht) {
            for (Node child : this.children) {
                if (child == null) continue;
                if (child instanceof SplitNode) {
                    ((EFDTSplitNode)child).killSubtree(ht);
                    continue;
                }
                if (child instanceof ActiveLearningNode) {
                    --ht.activeLeafNodeCount;
                    continue;
                }
                if (!(child instanceof InactiveLearningNode)) continue;
                --ht.inactiveLeafNodeCount;
            }
        }

        public AttributeSplitSuggestion[] getBestSplitSuggestions(SplitCriterion criterion, EFDT ht) {
            LinkedList<AttributeSplitSuggestion> bestSuggestions = new LinkedList<AttributeSplitSuggestion>();
            double[] preSplitDist = this.observedClassDistribution.getArrayCopy();
            if (!ht.noPrePruneOption.isSet()) {
                bestSuggestions.add(new AttributeSplitSuggestion(null, new double[0][], criterion.getMeritOfSplit(preSplitDist, new double[][]{preSplitDist})));
            }
            for (int i = 0; i < this.attributeObservers.size(); ++i) {
                AttributeSplitSuggestion bestSuggestion;
                AttributeClassObserver obs = this.attributeObservers.get(i);
                if (obs == null || (bestSuggestion = obs.getBestEvaluatedSplitSuggestion(criterion, preSplitDist, i, ht.binarySplitsOption.isSet())) == null) continue;
                bestSuggestions.add(bestSuggestion);
            }
            return bestSuggestions.toArray(new AttributeSplitSuggestion[bestSuggestions.size()]);
        }

        @Override
        public void learnFromInstance(Instance inst, EFDT ht, EFDTSplitNode parent, int parentBranch) {
            int childBranch;
            Node child;
            ++this.nodeTime;
            this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                int instAttIndex = EFDT.modelAttIndexToInstanceAttIndex(i, inst);
                AttributeClassObserver obs = this.attributeObservers.get(i);
                if (obs == null) {
                    obs = inst.attribute(instAttIndex).isNominal() ? ht.newNominalClassObserver() : ht.newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                obs.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
            }
            if (ht.numInstances % ht.reEvalPeriodOption.getValue() == 0) {
                this.reEvaluateBestSplit(this, parent, parentBranch);
            }
            if ((child = this.getChild(childBranch = this.instanceChildIndex(inst))) != null) {
                ((EFDTNode)((Object)child)).learnFromInstance(inst, ht, this, childBranch);
            }
        }

        protected void reEvaluateBestSplit(EFDTSplitNode node, EFDTSplitNode parent, int parentIndex) {
            node.addToSplitAttempts(1);
            int currentSplit = -1;
            if (this.splitTest != null) {
                currentSplit = this.splitTest.getAttsTestDependsOn()[0];
            }
            SplitCriterion splitCriterion = (SplitCriterion)EFDT.this.getPreparedClassOption(EFDT.this.splitCriterionOption);
            double hoeffdingBound = EFDT.computeHoeffdingBound(splitCriterion.getRangeOfMerit(node.getClassDistributionAtTimeOfCreation()), EFDT.this.splitConfidenceOption.getValue(), node.observedClassDistribution.sumOfValues());
            Object[] bestSplitSuggestions = node.getBestSplitSuggestions(splitCriterion, EFDT.this);
            Arrays.sort(bestSplitSuggestions);
            Object bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            for (Object bestSplitSuggestion : bestSplitSuggestions) {
                double currentSum;
                if (((AttributeSplitSuggestion)bestSplitSuggestion).splitTest != null) {
                    if (!node.getInfogainSum().containsKey(((AttributeSplitSuggestion)bestSplitSuggestion).splitTest.getAttsTestDependsOn()[0])) {
                        node.getInfogainSum().put(((AttributeSplitSuggestion)bestSplitSuggestion).splitTest.getAttsTestDependsOn()[0], 0.0);
                    }
                    currentSum = node.getInfogainSum().get(((AttributeSplitSuggestion)bestSplitSuggestion).splitTest.getAttsTestDependsOn()[0]);
                    node.getInfogainSum().put(((AttributeSplitSuggestion)bestSplitSuggestion).splitTest.getAttsTestDependsOn()[0], currentSum + ((AttributeSplitSuggestion)bestSplitSuggestion).merit);
                    continue;
                }
                currentSum = node.getInfogainSum().get(-1);
                node.getInfogainSum().put(-1, currentSum + ((AttributeSplitSuggestion)bestSplitSuggestion).merit);
            }
            double bestSuggestionAverageMerit = ((AttributeSplitSuggestion)bestSuggestion).splitTest == null ? node.getInfogainSum().get(-1) / (double)node.getNumSplitAttempts() : node.getInfogainSum().get(((AttributeSplitSuggestion)bestSuggestion).splitTest.getAttsTestDependsOn()[0]) / (double)node.getNumSplitAttempts();
            double currentAverageMerit = node.splitTest == null ? node.getInfogainSum().get(-1) / (double)node.getNumSplitAttempts() : node.getInfogainSum().get(node.splitTest.getAttsTestDependsOn()[0]) / (double)node.getNumSplitAttempts();
            double tieThreshold = EFDT.this.tieThresholdOption.getValue();
            double deltaG = bestSuggestionAverageMerit - currentAverageMerit;
            if (deltaG > hoeffdingBound || hoeffdingBound < tieThreshold && deltaG > tieThreshold / 2.0) {
                System.err.println(EFDT.this.numInstances);
                Object splitDecision = bestSuggestion;
                if (((AttributeSplitSuggestion)splitDecision).splitTest == null) {
                    node.killSubtree(EFDT.this);
                    EFDTLearningNode replacement = (EFDTLearningNode)EFDT.this.newLearningNode();
                    replacement.setInfogainSum(node.getInfogainSum());
                    if (node.getParent() != null) {
                        node.getParent().setChild(parentIndex, replacement);
                    } else {
                        assert (node.isRoot());
                        node.setRoot(true);
                    }
                } else {
                    SplitNode newSplit = EFDT.this.newSplitNode(((AttributeSplitSuggestion)splitDecision).splitTest, node.getObservedClassDistribution(), ((AttributeSplitSuggestion)splitDecision).numSplits());
                    ((EFDTSplitNode)newSplit).attributeObservers = node.attributeObservers;
                    newSplit.setInfogainSum(node.getInfogainSum());
                    if (node.splitTest == ((AttributeSplitSuggestion)splitDecision).splitTest && node.splitTest.getClass() == NumericAttributeBinaryTest.class && (EFDT.this.argmax(((AttributeSplitSuggestion)splitDecision).resultingClassDistributions[0]) == EFDT.this.argmax(node.getChild(0).getObservedClassDistribution()) || EFDT.this.argmax(((AttributeSplitSuggestion)splitDecision).resultingClassDistributions[1]) == EFDT.this.argmax(node.getChild(1).getObservedClassDistribution()))) {
                        for (int i = 0; i < ((AttributeSplitSuggestion)splitDecision).numSplits(); ++i) {
                            ((EFDTSplitNode)newSplit).setChild(i, this.getChild(i));
                        }
                    } else {
                        this.killSubtree(EFDT.this);
                        for (int i = 0; i < ((AttributeSplitSuggestion)splitDecision).numSplits(); ++i) {
                            double[] j = ((AttributeSplitSuggestion)splitDecision).resultingClassDistributionFromSplit(i);
                            LearningNode newChild = EFDT.this.newLearningNode(((AttributeSplitSuggestion)splitDecision).resultingClassDistributionFromSplit(i));
                            if (((AttributeSplitSuggestion)splitDecision).splitTest.getClass() == NominalAttributeBinaryTest.class || ((AttributeSplitSuggestion)splitDecision).splitTest.getClass() == NominalAttributeMultiwayTest.class) {
                                newChild.usedNominalAttributes = new ArrayList<Integer>(node.usedNominalAttributes);
                                newChild.usedNominalAttributes.add(((AttributeSplitSuggestion)splitDecision).splitTest.getAttsTestDependsOn()[0]);
                            }
                            ((EFDTSplitNode)newSplit).setChild(i, newChild);
                        }
                        --EFDT.this.activeLeafNodeCount;
                        ++EFDT.this.decisionNodeCount;
                        EFDT.this.activeLeafNodeCount += ((AttributeSplitSuggestion)splitDecision).numSplits();
                    }
                    if (parent == null) {
                        ((EFDTNode)((Object)newSplit)).setRoot(true);
                        ((EFDTNode)((Object)newSplit)).setParent(null);
                        EFDT.this.treeRoot = newSplit;
                    } else {
                        ((EFDTNode)((Object)newSplit)).setRoot(false);
                        ((EFDTNode)((Object)newSplit)).setParent(parent);
                        parent.setChild(parentIndex, newSplit);
                    }
                }
            }
        }

        @Override
        public void setParent(EFDTSplitNode parent) {
            this.parent = parent;
        }

        @Override
        public EFDTSplitNode getParent() {
            return this.parent;
        }
    }

    public static class SplitNode
    extends Node {
        private static final long serialVersionUID = 1L;
        protected InstanceConditionalTest splitTest;
        protected AutoExpandVector<Node> children;

        @Override
        public int calcByteSize() {
            return super.calcByteSize() + (int)(SizeOf.sizeOf(this.children) + SizeOf.fullSizeOf(this.splitTest));
        }

        @Override
        public int calcByteSizeIncludingSubtree() {
            int byteSize = this.calcByteSize();
            for (Node child : this.children) {
                if (child == null) continue;
                byteSize += child.calcByteSizeIncludingSubtree();
            }
            return byteSize;
        }

        public SplitNode(InstanceConditionalTest splitTest, double[] classObservations, int size) {
            super(classObservations);
            this.splitTest = splitTest;
            this.children = new AutoExpandVector(size);
        }

        public SplitNode(InstanceConditionalTest splitTest, double[] classObservations) {
            super(classObservations);
            this.splitTest = splitTest;
            this.children = new AutoExpandVector();
        }

        public int numChildren() {
            return this.children.size();
        }

        public void setChild(int index, Node child) {
            if (this.splitTest.maxBranches() >= 0 && index >= this.splitTest.maxBranches()) {
                throw new IndexOutOfBoundsException();
            }
            this.children.set(index, child);
        }

        public Node getChild(int index) {
            return this.children.get(index);
        }

        public int instanceChildIndex(Instance inst) {
            return this.splitTest.branchForInstance(inst);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public FoundNode filterInstanceToLeaf(Instance inst, SplitNode parent, int parentBranch) {
            int childIndex = this.instanceChildIndex(inst);
            if (childIndex >= 0) {
                Node child = this.getChild(childIndex);
                if (child != null) {
                    return child.filterInstanceToLeaf(inst, this, childIndex);
                }
                return new FoundNode(null, this, childIndex);
            }
            return new FoundNode(this, parent, parentBranch);
        }

        @Override
        public void describeSubtree(EFDT ht, StringBuilder out, int indent) {
            for (int branch = 0; branch < this.numChildren(); ++branch) {
                Node child = this.getChild(branch);
                if (child == null) continue;
                StringUtils.appendIndented(out, indent, "if ");
                out.append(this.splitTest.describeConditionForBranch(branch, ht.getModelContext()));
                out.append(": ");
                StringUtils.appendNewline(out);
                child.describeSubtree(ht, out, indent + 2);
            }
        }

        @Override
        public int subtreeDepth() {
            int maxChildDepth = 0;
            for (Node child : this.children) {
                int depth;
                if (child == null || (depth = child.subtreeDepth()) <= maxChildDepth) continue;
                maxChildDepth = depth;
            }
            return maxChildDepth + 1;
        }
    }

    public static class Node
    extends AbstractMOAObject {
        private HashMap<Integer, Double> infogainSum;
        private int numSplitAttempts = 0;
        private static final long serialVersionUID = 1L;
        protected DoubleVector observedClassDistribution;
        protected DoubleVector classDistributionAtTimeOfCreation;
        protected int nodeTime;
        protected List<Integer> usedNominalAttributes = new ArrayList<Integer>();

        public Node(double[] classObservations) {
            this.observedClassDistribution = new DoubleVector(classObservations);
            this.classDistributionAtTimeOfCreation = new DoubleVector(classObservations);
            this.infogainSum = new HashMap();
            this.infogainSum.put(-1, 0.0);
        }

        public int getNumSplitAttempts() {
            return this.numSplitAttempts;
        }

        public void addToSplitAttempts(int i) {
            this.numSplitAttempts += i;
        }

        public HashMap<Integer, Double> getInfogainSum() {
            return this.infogainSum;
        }

        public void setInfogainSum(HashMap<Integer, Double> igs) {
            this.infogainSum = igs;
        }

        public int calcByteSize() {
            return (int)(SizeOf.sizeOf(this) + SizeOf.fullSizeOf(this.observedClassDistribution));
        }

        public int calcByteSizeIncludingSubtree() {
            return this.calcByteSize();
        }

        public boolean isLeaf() {
            return true;
        }

        public FoundNode filterInstanceToLeaf(Instance inst, SplitNode parent, int parentBranch) {
            return new FoundNode(this, parent, parentBranch);
        }

        public double[] getObservedClassDistribution() {
            return this.observedClassDistribution.getArrayCopy();
        }

        public double[] getClassVotes(Instance inst, EFDT ht) {
            return this.observedClassDistribution.getArrayCopy();
        }

        public double[] getClassDistributionAtTimeOfCreation() {
            return this.classDistributionAtTimeOfCreation.getArrayCopy();
        }

        public boolean observedClassDistributionIsPure() {
            return this.observedClassDistribution.numNonZeroEntries() < 2;
        }

        public void describeSubtree(EFDT ht, StringBuilder out, int indent) {
            StringUtils.appendIndented(out, indent, "Leaf ");
            out.append(ht.getClassNameString());
            out.append(" = ");
            out.append(ht.getClassLabelString(this.observedClassDistribution.maxIndex()));
            out.append(" weights: ");
            this.observedClassDistribution.getSingleLineDescription(out, ht.treeRoot.observedClassDistribution.numValues());
            StringUtils.appendNewline(out);
        }

        public int subtreeDepth() {
            return 0;
        }

        public double calculatePromise() {
            double totalSeen = this.observedClassDistribution.sumOfValues();
            return totalSeen > 0.0 ? totalSeen - this.observedClassDistribution.getValue(this.observedClassDistribution.maxIndex()) : 0.0;
        }

        @Override
        public void getDescription(StringBuilder sb, int indent) {
            this.describeSubtree(null, sb, indent);
        }
    }

    public static class FoundNode {
        public Node node;
        public SplitNode parent;
        public int parentBranch;

        public FoundNode(Node node, SplitNode parent, int parentBranch) {
            this.node = node;
            this.parent = parent;
            this.parentBranch = parentBranch;
        }
    }

    public static interface EFDTNode {
        public boolean isRoot();

        public void setRoot(boolean var1);

        public void learnFromInstance(Instance var1, EFDT var2, EFDTSplitNode var3, int var4);

        public void setParent(EFDTSplitNode var1);

        public EFDTSplitNode getParent();
    }
}

